/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509.ec;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.FieldID;
import de.bos_bremen.ci.asn1.x509.Version;
import de.bos_bremen.ci.asn1.x509.ec.ECPKParameters;
import de.bos_bremen.ci.asn1.x509.ec.ECPoint;
import de.bos_bremen.ci.asn1.x509.ec.ECurve;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class ECParameters
extends ANY
implements ECPKParameters,
Dumpable,
Flattable {
    Version version;
    FieldID fieldID;
    ECurve curve;
    ECPoint base;
    INTEGER order;
    INTEGER cofactor;

    public ECParameters(Run run) throws ParseException {
        super(run, false);
        byte tag = run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + run.pos(), run.pos());
        }
        int end = run.readLength();
        this.setEnd(end += run.pos());
        this.version = new Version(run);
        this.fieldID = new FieldID(run);
        this.curve = new ECurve(run);
        this.base = new ECPoint(run);
        this.order = new INTEGER(run);
        if (run.pos() >= end) {
            return;
        }
        this.cofactor = new INTEGER(run);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("version: " + this.version.getValueAsString());
        w.newLine();
        this.fieldID.dump(w);
        w.newLine();
        this.curve.dump(w);
        w.newLine();
        w.write("base: " + this.base.getValueAsString());
        w.newLine();
        w.write("order: " + this.order.getValueAsHexedString());
        if (this.cofactor != null) {
            w.newLine();
            w.write("cofactor: " + this.cofactor.getValueAsHexedString());
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        result.add(new Flattable.Pair(res.getString("general.publickey.ec.ecparameters.version"), this.version.getValueAsString()));
        result.addAll(this.fieldID.flatten(res, _short));
        result.addAll(this.curve.flatten(res, _short));
        result.add(new Flattable.Pair(res.getString("general.publickey.ec.ecparameters.base"), this.base.getValueAsString()));
        result.add(new Flattable.Pair(res.getString("general.publickey.ec.ecparameters.order"), this.order.getValueAsHexedString()));
        if (this.cofactor != null) {
            result.add(new Flattable.Pair(res.getString("general.publickey.ec.ecparameters.cofactor"), this.cofactor.getValueAsHexedString()));
        }
        return result;
    }
}

