/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.FlattableUtil;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.Time;
import java.io.IOException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;

public class Validity
extends ANY
implements Dumpable,
Flattable {
    Time notBefore;
    Time notAfter;

    public Validity(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.get();
        if (tag != 48 && tag != 23 && tag != 24) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        if (tag == 48) {
            _run.next();
            _run.readLength();
        }
        this.notBefore = Time.Factory.generate(_run);
        this.notAfter = Time.Factory.generate(_run);
        this.setEnd(_run.pos());
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(this.notBefore.toString());
        w.newLine();
        w.write(this.notAfter.toString());
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public Date getNotBefore() {
        return this.notBefore.getDate();
    }

    public Date getNotAfter() {
        return this.notAfter.getDate();
    }

    public Time getNotBeforeTime() {
        return this.notBefore;
    }

    public Time getNotAfterTime() {
        return this.notAfter;
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        DateFormat sdf = FlattableUtil.newDateFormat(res, _short);
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        pairs.add(new Flattable.Pair(res.getString("general.validfrom"), sdf.format(this.notBefore.getDate())));
        pairs.add(new Flattable.Pair(res.getString("general.validto"), sdf.format(this.notAfter.getDate())));
        return pairs;
    }
}

