/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.CharString;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.DisplayText;
import de.bos_bremen.ci.asn1.x509.NoticeReference;
import de.bos_bremen.ci.asn1.x509.PolicyQualifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class UserNotice
extends ANY
implements Dumpable,
PolicyQualifier {
    NoticeReference noticeRef;
    CharString explicitText;

    public UserNotice(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        if (_run.pos() >= end) {
            return;
        }
        tag = _run.get();
        if (tag == 48) {
            this.noticeRef = new NoticeReference(_run);
            if (_run.pos() >= end) {
                return;
            }
            tag = _run.get();
        }
        this.explicitText = DisplayText.Factory.createDisplayText(_run);
    }

    public NoticeReference getNoticeReference() {
        return this.noticeRef;
    }

    public String getExplicitText() {
        return this.explicitText == null ? null : this.explicitText.getValue();
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        if (this.noticeRef != null) {
            this.noticeRef.dump(w);
        }
        if (this.explicitText != null) {
            if (this.noticeRef != null) {
                w.newLine();
            }
            this.explicitText.dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        if (this.noticeRef != null) {
            result.addAll(this.noticeRef.flatten(res, false));
        }
        if (this.explicitText != null) {
            result.add(new Flattable.Pair(res.getString("explicitText"), this.explicitText.getValue()));
        }
        return result;
    }
}

