/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.CertificateSerialNumber;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.Name;
import de.bos_bremen.ci.asn1.x509.SubjectPublicKeyInfo;
import de.bos_bremen.ci.asn1.x509.UniqueIdentifier;
import de.bos_bremen.ci.asn1.x509.Validity;
import de.bos_bremen.ci.asn1.x509.Version;
import java.io.IOException;

public class TBSCertificate
extends ANY
implements Dumpable {
    Version version;
    CertificateSerialNumber serialNumber;
    AlgorithmIdentifier signature;
    Name issuer;
    Validity validity;
    Name subject;
    SubjectPublicKeyInfo subjectPublicKeyInfo;
    UniqueIdentifier issuerUniqueID;
    UniqueIdentifier subjectUniqueID;
    Extensions extensions;

    public TBSCertificate(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        tag = _run.get();
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 0) {
            _run.next();
            _run.readLength();
            this.version = new Version(_run);
        } else {
            this.version = new Version(0);
        }
        this.serialNumber = new CertificateSerialNumber(_run);
        this.signature = new AlgorithmIdentifier(_run);
        this.issuer = new Name(_run);
        this.validity = new Validity(_run);
        this.subject = new Name(_run);
        this.subjectPublicKeyInfo = new SubjectPublicKeyInfo(_run);
        while (_run.pos() < end) {
            tag = _run.get();
            if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 1) {
                this.issuerUniqueID = new UniqueIdentifier(_run, true);
                continue;
            }
            if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 2) {
                this.subjectUniqueID = new UniqueIdentifier(_run, true);
                continue;
            }
            if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 3) {
                _run.next();
                _run.readLength();
                this.extensions = new Extensions(_run);
                continue;
            }
            throw new ParseException(this, "tag " + ASN1.Factory.toString(tag) + " is unexpected at index " + _run.pos(), _run.pos());
        }
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(this.version.toString());
        w.newLine();
        w.write(this.serialNumber.toString());
        w.newLine();
        this.signature.dump(w);
        w.newLine();
        this.issuer.dump(w);
        w.newLine();
        this.validity.dump(w);
        w.newLine();
        this.subject.dump(w);
        w.newLine();
        this.subjectPublicKeyInfo.dump(w);
        w.newLine();
        if (this.issuerUniqueID != null) {
            w.write(this.issuerUniqueID.toString());
            w.newLine();
        }
        if (this.subjectUniqueID != null) {
            w.write(this.subjectUniqueID.toString());
            w.newLine();
        }
        if (this.extensions != null) {
            this.extensions.dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public Name getIssuer() {
        return this.issuer;
    }

    public UniqueIdentifier getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    public CertificateSerialNumber getSerialNumber() {
        return this.serialNumber;
    }

    public AlgorithmIdentifier getSignature() {
        return this.signature;
    }

    public Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        return this.subjectPublicKeyInfo;
    }

    public UniqueIdentifier getSubjectUniqueID() {
        return this.subjectUniqueID;
    }

    public Validity getValidity() {
        return this.validity;
    }

    public Version getVersion() {
        return this.version;
    }
}

