/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AbstractFlattableDumpablePublicKey;
import de.bos_bremen.ci.asn1.x509.FlattableDumpablePublicKeyFactory;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class SubjectPublicKeyInfo
extends ANY
implements Dumpable,
Flattable,
PublicKey {
    private static final long serialVersionUID = 1L;
    public transient AlgorithmIdentifier algorithm;
    public transient BITSTRING subjectPublicKey;

    public SubjectPublicKeyInfo(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.algorithm = new AlgorithmIdentifier(_run);
        this.subjectPublicKey = new BITSTRING(_run);
    }

    @Override
    public String getAlgorithm() {
        if (this.algorithm.getAlgorithmName().contains("RSA") || this.algorithm.getAlgorithmName().contains("PSS")) {
            return "RSA";
        }
        if (this.algorithm.getAlgorithmName().contains("DSA")) {
            return "DSA";
        }
        if (this.algorithm.getAlgorithmName().contains("ECDSA")) {
            return "EC";
        }
        return this.algorithm.getAlgorithmName();
    }

    public AlgorithmIdentifier getAlgorithmIdentifier() {
        return this.algorithm;
    }

    @Override
    public byte[] getEncoded() {
        return this.asByteArray();
    }

    @Override
    public String getFormat() {
        return "X509";
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        this.algorithm.dump(w);
        w.newLine();
        AbstractFlattableDumpablePublicKey publicKey = this.getFlattableDumpablePublicKey();
        if (publicKey != null) {
            publicKey.dump(w);
        } else {
            w.write(this.subjectPublicKey.getValueAsHexedString());
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    private AbstractFlattableDumpablePublicKey getFlattableDumpablePublicKey() {
        return FlattableDumpablePublicKeyFactory.createKey(this);
    }

    public PublicKey getPublicKey() {
        String[] providerNames;
        for (String providerName : providerNames = new String[]{null, "BC"}) {
            try {
                KeyFactory keyFactory = providerName == null ? KeyFactory.getInstance(this.getAlgorithm()) : KeyFactory.getInstance(this.getAlgorithm(), providerName);
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(this.getEncoded());
                PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
                return publicKey;
            }
            catch (NoSuchProviderException noSuchProviderException) {
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle _res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        result.add(new Flattable.Pair(_res.getString("general.publickey"), null));
        AbstractFlattableDumpablePublicKey publicKey = this.getFlattableDumpablePublicKey();
        if (publicKey != null) {
            result.addAll(this.getAlgorithmIdentifier().flatten(_res, _short));
            result.addAll(publicKey.flatten(_res, _short));
        } else {
            result.addAll(this.algorithm.flatten(_res, _short));
            result.add(new Flattable.Pair(_res.getString("general.publickey.key"), this.subjectPublicKey.toString()));
        }
        return result;
    }
}

