/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.GeneralNames;
import de.bos_bremen.ci.asn1.x509.IssuerSerial;
import de.bos_bremen.ci.asn1.x509.Name;

public interface Subject
extends Dumpable,
Flattable {
    public String getDisplayName();

    public boolean matches(FlatCertificate var1);

    public Name getName();

    public static final class Factory {
        public static final Subject generate(Run _run) throws ParseException {
            return Factory.generate(_run, false);
        }

        public static final Subject generate(Run _run, boolean implicit) throws ParseException {
            byte tag = _run.next();
            _run.readLength();
            if (ASN1.Factory.isTaggedAs(tag, 0)) {
                return new IssuerSerial(_run);
            }
            if (ASN1.Factory.isTaggedAs(tag, 1)) {
                return new GeneralNames(_run);
            }
            ANY any = new ANY(_run, implicit);
            throw new ParseException(any, "no representation for choice \"" + Hex.hexify(tag) + "\" at index " + _run.pos(), _run.pos());
        }
    }
}

