/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.asn1.AbstractString;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.x509.AttributeTypeAndValue;
import de.bos_bremen.ci.asn1.x509.Name;
import de.bos_bremen.ci.asn1.x509.RelativeDistinguishedName;
import java.util.ArrayList;
import java.util.List;

class RelativeDistinguishedNameMatcher {
    private OBJECTIDENTIFIER matchingType;

    public RelativeDistinguishedNameMatcher(OBJECTIDENTIFIER type) {
        this.matchingType = type;
    }

    public List<String> getMatches(Name name) {
        ArrayList<String> matches = new ArrayList<String>();
        if (name.getRelativeDistinguishedNames() == null) {
            return null;
        }
        for (RelativeDistinguishedName relativeDistinguishedName : name.getRelativeDistinguishedNames()) {
            for (AttributeTypeAndValue entry : relativeDistinguishedName.attributeTypeAndValues) {
                if (!this.matchingType.equals(entry.type)) continue;
                if (entry.value instanceof AbstractString) {
                    AbstractString cs = (AbstractString)entry.value;
                    matches.add(cs.getValue());
                    continue;
                }
                matches.add(entry.value.getValueAsString());
            }
        }
        return matches;
    }
}

