/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AttributeTypeAndValue;
import de.bos_bremen.ci.asn1.x509.DistributionPointName;
import de.bos_bremen.ci.asn1.x509.NameUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;

public class RelativeDistinguishedName
extends ANY
implements Dumpable,
DistributionPointName {
    Set<AttributeTypeAndValue> attributeTypeAndValues;

    public RelativeDistinguishedName(Run _run) throws ParseException {
        this(_run, false);
    }

    public RelativeDistinguishedName(Run _run, boolean implicit) throws ParseException {
        super(_run, implicit);
        byte tag = _run.next();
        if (!implicit && tag != 49) {
            throw new ParseException(this, ASN1.Factory.toString((byte)49) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.attributeTypeAndValues = new HashSet<AttributeTypeAndValue>();
        while (_run.pos() < end) {
            AttributeTypeAndValue attributeTypeAndValue = new AttributeTypeAndValue(_run);
            this.attributeTypeAndValues.add(attributeTypeAndValue);
        }
    }

    RelativeDistinguishedName(String rdn) throws ParseException {
        this();
        String ava;
        int end;
        int offset = 0;
        for (end = 0; end < rdn.length(); ++end) {
            if (NameUtil.isUnescapedDoubleQuote(rdn, end)) {
                end = NameUtil.jumptToQuotationEnd(rdn, end);
                continue;
            }
            if (!RelativeDistinguishedName.isUnescapedAVASeparator(rdn, end)) continue;
            ava = rdn.substring(offset, end);
            this.addAttributeTypeAndValue(new AttributeTypeAndValue(ava));
            offset = end + 1;
        }
        if (end > offset) {
            ava = rdn.substring(offset);
            this.addAttributeTypeAndValue(new AttributeTypeAndValue(ava));
        }
    }

    private static boolean isUnescapedAVASeparator(String rdn, int pos) {
        return rdn.charAt(pos) == '+' && NameUtil.isUnescaped(rdn, pos);
    }

    RelativeDistinguishedName(OBJECTIDENTIFIER oid, ANY value) {
        this.attributeTypeAndValues = new HashSet<AttributeTypeAndValue>();
        AttributeTypeAndValue attributeTypeAndValue = new AttributeTypeAndValue(oid, value);
        this.attributeTypeAndValues.add(attributeTypeAndValue);
    }

    RelativeDistinguishedName() {
        this.attributeTypeAndValues = new HashSet<AttributeTypeAndValue>();
    }

    public void addAttributeTypeAndValue(AttributeTypeAndValue atav) {
        this.attributeTypeAndValues.add(atav);
    }

    public List<AttributeTypeAndValue> getAttributeTypeAndValues() {
        return Arrays.asList(this.attributeTypeAndValues.toArray(new AttributeTypeAndValue[0]));
    }

    public Set<AttributeTypeAndValue> getAttributeTypeAndValuesSet() {
        return this.attributeTypeAndValues;
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof RelativeDistinguishedName)) {
            return false;
        }
        RelativeDistinguishedName otherRDN = (RelativeDistinguishedName)other;
        HashSet<AttributeTypeAndValue> otherATVs = new HashSet<AttributeTypeAndValue>(otherRDN.getAttributeTypeAndValuesSet());
        if (this.attributeTypeAndValues.size() != otherATVs.size()) {
            return false;
        }
        for (AttributeTypeAndValue atv : this.attributeTypeAndValues) {
            if (otherATVs.remove(atv)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 1;
        for (AttributeTypeAndValue atv : this.attributeTypeAndValues) {
            result *= atv.hashCode();
        }
        return result;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (!this.attributeTypeAndValues.isEmpty()) {
            w.indent();
            w.newLine();
            Iterator<AttributeTypeAndValue> iter = this.attributeTypeAndValues.iterator();
            while (iter.hasNext()) {
                AttributeTypeAndValue attributeTypeAndValue = iter.next();
                attributeTypeAndValue.dump(w);
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        ArrayList<AttributeTypeAndValue> entries = new ArrayList<AttributeTypeAndValue>(this.attributeTypeAndValues);
        Collections.sort(entries, NameUtil.getComparator());
        for (AttributeTypeAndValue entry : entries) {
            result.addAll(entry.flatten(res, false));
        }
        return result;
    }

    @Override
    public int getLength() {
        if (this.getSource() != null) {
            return super.getLength();
        }
        int result = 1;
        int length = 0;
        for (AttributeTypeAndValue atav : this.attributeTypeAndValues) {
            length += atav.getLength();
        }
        result += INTEGER.lengthLength(length);
        for (AttributeTypeAndValue atav : this.attributeTypeAndValues) {
            result += atav.getLength();
        }
        return result;
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        os.write(49);
        int length = 0;
        for (AttributeTypeAndValue atav : this.attributeTypeAndValues) {
            length += atav.getLength();
        }
        INTEGER.writeLength(os, length);
        for (AttributeTypeAndValue atav : this.attributeTypeAndValues) {
            atav.encode(os);
        }
    }

    public String getAsDirectoryString() {
        StringBuilder sb = new StringBuilder();
        Iterator<AttributeTypeAndValue> iter = this.attributeTypeAndValues.iterator();
        while (iter.hasNext()) {
            AttributeTypeAndValue atv = iter.next();
            sb.append(atv.getAsDirectoryString());
            if (!iter.hasNext()) continue;
            sb.append('+');
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getAsDirectoryString();
    }
}

