/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.algorithm_identifier.AlgorithmService;
import de.bos_bremen.algorithm_identifier.DigestAlgorithm;
import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.AlgorithmIdentifierParameter;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class RSASSAPSSParameters
extends ANY
implements Dumpable,
Flattable,
AlgorithmIdentifierParameter {
    public static final OBJECTIDENTIFIER OID_MGF1 = OBJECTIDENTIFIER.valueOf("1.2.840.113549.1.1.8");
    private static final AlgorithmIdentifier DEFAULT_DIGEST;
    private static final AlgorithmIdentifier DEFAULT_MGF;
    AlgorithmIdentifier d = DEFAULT_DIGEST;
    AlgorithmIdentifier mgf = DEFAULT_MGF;
    INTEGER saltLength = new INTEGER(20);
    INTEGER trailerField = new INTEGER(1);
    DigestAlgorithm digestAlgorithm;
    DigestAlgorithm mgfDigestAlgorithm;

    public RSASSAPSSParameters(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        block6: while (_run.pos() < end) {
            tag = _run.next();
            if (!ASN1.Factory.isTaggedConstructed(tag)) {
                throw new ParseException(this, ASN1.Factory.toString((byte)-96) + " expected at index " + _run.pos(), _run.pos());
            }
            int t = tag & 0xF;
            switch (t) {
                case 0: {
                    _run.readLength();
                    this.d = new AlgorithmIdentifier(_run);
                    continue block6;
                }
                case 1: {
                    _run.readLength();
                    this.mgf = new AlgorithmIdentifier(_run);
                    if (OID_MGF1.equals(this.mgf.getOID())) continue block6;
                    throw new ParseException("unknown mgf used " + this.mgf.getOID().getOID());
                }
                case 2: {
                    _run.readLength();
                    this.saltLength = new INTEGER(_run);
                    continue block6;
                }
                case 3: {
                    _run.readLength();
                    this.trailerField = new INTEGER(_run);
                    continue block6;
                }
            }
            throw new ParseException("unknown tag " + t);
        }
        this.digestAlgorithm = AlgorithmService.getDigestForOID((String)this.d.getOID().getOID());
        this.mgfDigestAlgorithm = AlgorithmService.getDigestForOID((String)((AlgorithmIdentifier)this.mgf.getParameters()).getOID().getOID());
    }

    public AlgorithmIdentifier getMGF() {
        return this.mgf;
    }

    public INTEGER getSaltLength() {
        return this.saltLength;
    }

    public INTEGER getTrailerField() {
        return this.trailerField;
    }

    public DigestAlgorithm getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public DigestAlgorithm getMGFDigestAlgorithm() {
        return this.mgfDigestAlgorithm;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("digest: " + this.digestAlgorithm.getName());
        w.write("mgf: MGF1{" + this.mgf.getParameters() + "}");
        w.write("salt length: " + this.saltLength.getValue());
        w.newLine();
        w.write("trailer field: " + this.trailerField.getValue());
        w.newLine();
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle bundle, boolean onlyShortList) {
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        return pairs;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("RSASSAPSSParameters[");
        sb.append(this.digestAlgorithm.getName());
        sb.append(", MGF1[" + this.mgfDigestAlgorithm.getName() + "]");
        sb.append(", salt length: " + this.saltLength.getValue());
        sb.append(", trailer field: " + this.trailerField.getValue());
        sb.append("]");
        return sb.toString();
    }

    static {
        try {
            DEFAULT_DIGEST = AlgorithmIdentifier.valueOf(AlgorithmService.getDigestForName((String)"SHA1").getOID());
        }
        catch (ParseException e) {
            throw new RuntimeException("cannot create algorithm identifier SHA1", e);
        }
        try {
            DEFAULT_MGF = new AlgorithmIdentifier(OID_MGF1, (ANY)DEFAULT_DIGEST);
        }
        catch (ParseException e) {
            throw new RuntimeException("cannot create algorithm identifier MGF1 with default SHA1", e);
        }
    }
}

