/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AbstractFlattableDumpablePublicKey;
import de.bos_bremen.ci.asn1.x509.SubjectPublicKeyInfo;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class RSAPublicKey
extends AbstractFlattableDumpablePublicKey
implements java.security.interfaces.RSAPublicKey {
    private static final long serialVersionUID = 1L;
    private transient INTEGER publicExponent;
    private transient INTEGER modulus;

    public RSAPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) throws ParseException {
        super(subjectPublicKeyInfo);
    }

    @Override
    protected void initialize() throws ParseException {
        Run _run = Run.create(this.subjectPublicKeyInfo.subjectPublicKey.getSource(), this.subjectPublicKeyInfo.subjectPublicKey.getOffset());
        byte tag = _run.next();
        _run.readLength();
        tag = _run.next();
        if (tag == 0) {
            tag = _run.next();
        }
        if (tag != 48) {
            throw new ParseException(this.subjectPublicKeyInfo.subjectPublicKey, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        _run.readLength();
        this.modulus = new INTEGER(_run);
        this.publicExponent = new INTEGER(_run);
    }

    @Override
    public BigInteger getPublicExponent() {
        return this.publicExponent.getValue().abs();
    }

    public String getHexedPublicExponent() {
        return this.publicExponent.getValueAsHexedString();
    }

    @Override
    public BigInteger getModulus() {
        return this.modulus.getValue().abs();
    }

    public String getHexedModulus() {
        return this.modulus.getValueAsHexedString();
    }

    @Override
    public boolean equals(Object _o) {
        if (_o == null) {
            return false;
        }
        if (_o == this) {
            return true;
        }
        if (!(_o instanceof RSAPublicKey)) {
            return false;
        }
        RSAPublicKey o = (RSAPublicKey)_o;
        return this.getPublicExponent().equals(o.getPublicExponent()) && this.getModulus().equals(o.getModulus());
    }

    @Override
    public int hashCode() {
        return this.getPublicExponent().hashCode() ^ this.getModulus().hashCode();
    }

    @Override
    public String toString() {
        return "RSAPublicKey[public exp=" + this.getPublicExponent() + ", modulus=" + this.getModulus() + "]";
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        String qualifiedClassName = this.getClass().getName();
        String className = qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
        w.write(className);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("Modulus: ");
        w.write(this.modulus.getValueAsString());
        w.newLine();
        w.write("Exponent: ");
        w.write(this.publicExponent.getValueAsString());
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle _res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        String l = Integer.toString(this.modulus.getValue().abs().bitLength());
        result.add(new Flattable.Pair(_res.getString("general.publickey.rsa.parameters.modulus.length"), l + " Bit"));
        result.add(new Flattable.Pair(_res.getString("general.publickey.rsa.parameters.modulus"), this.modulus.getValueAsHexedString()));
        result.add(new Flattable.Pair(_res.getString("general.publickey.rsa.parameters.exponent"), this.publicExponent.getValueAsHexedString()));
        return result;
    }
}

