/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.ETSIQCObjectIdentifier;
import de.bos_bremen.ci.asn1.x509.MonetaryValue;
import de.bos_bremen.ci.asn1.x509.PKIDisclosureStatement;
import de.bos_bremen.ci.asn1.x509.PSD2Statement;
import de.bos_bremen.ci.asn1.x509.QcRetentionPeriod;
import de.bos_bremen.ci.asn1.x509.StatementValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class QCStatement
extends ANY
implements Dumpable,
Flattable {
    public static final String QcCompliance = "0.4.0.1862.1.1";
    public static final String QcSSCD = "0.4.0.1862.1.4";
    private OBJECTIDENTIFIER statementId;
    private String name4oid;
    private Flattable flattable;

    public QCStatement(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.statementId = new OBJECTIDENTIFIER(_run);
        this.name4oid = "Unknown";
        if (_run.pos() < end) {
            if ("0.4.0.1862.1.2".equals(this.statementId.getOID())) {
                this.flattable = new MonetaryValue(_run);
                this.name4oid = "QcLimitValue";
            } else if ("0.4.0.1862.1.3".equals(this.statementId.getOID())) {
                this.flattable = new QcRetentionPeriod(_run);
                this.name4oid = "QcRetentionPeriod";
            } else if ("0.4.0.1862.1.5".equals(this.statementId.getOID())) {
                this.flattable = new PKIDisclosureStatement(_run);
                this.name4oid = "QcPDS";
            } else if ("0.4.0.1862.1.6".equals(this.statementId.getOID())) {
                this.flattable = new ETSIQCObjectIdentifier(_run);
                this.name4oid = "QcType";
            } else if ("0.4.0.19495.2".equals(this.statementId.getOID())) {
                this.flattable = new PSD2Statement(_run);
                this.name4oid = "QcPSD2";
            } else {
                this.flattable = new ANYStatementValue(_run);
            }
        } else if (QcCompliance.equals(this.statementId.getOID())) {
            this.name4oid = "QcCompliance";
        } else if (QcSSCD.equals(this.statementId.getOID())) {
            this.name4oid = "QcSSCD";
        }
    }

    public OBJECTIDENTIFIER getOID() {
        return this.statementId;
    }

    public String getName() {
        return this.name4oid;
    }

    public Flattable getValue() {
        return this.flattable;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(this.statementId.toString());
        if (this.flattable != null) {
            w.newLine();
            if (this.flattable instanceof Dumpable) {
                ((Dumpable)((Object)this.flattable)).dump(w);
            } else {
                w.write(this.flattable.toString());
            }
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        String value = this.statementId.getOID();
        try {
            value = res.getString(value);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (this.flattable != null) {
            result.addAll(this.flattable.flatten(res, _short));
        } else {
            result.add(new Flattable.Pair(null, value));
        }
        return result;
    }

    private static class ANYStatementValue
    extends ANY
    implements StatementValue {
        public ANYStatementValue(Run _run) {
            super(_run, false);
            _run.next();
            int length = _run.readLength();
            int end = length + _run.pos();
            this.setEnd(end);
            _run.skip(length);
        }

        @Override
        public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
            return Arrays.asList(this.getPair(res));
        }

        @Override
        public Flattable.Pair getPair(ResourceBundle res) {
            return new Flattable.Pair(res.getString("uninterpreted"), this.getValueAsString());
        }

        @Override
        public String getText() {
            return this.getValueAsString();
        }
    }
}

