/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.CharString;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.PrintableString;
import de.bos_bremen.ci.asn1.x509.DirectoryString;
import de.bos_bremen.ci.asn1.x509.NamingAuthority;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class ProfessionInfo
extends ANY
implements Dumpable,
Flattable {
    NamingAuthority namingAuthority;
    List<CharString> professionItems;
    List<OBJECTIDENTIFIER> professionOIDs;
    PrintableString registrationNumber;
    OCTETSTRING addProfessionInfo;

    public ProfessionInfo(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        tag = _run.get();
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 0) {
            _run.next();
            _run.readLength();
            this.namingAuthority = new NamingAuthority(_run);
        }
        _run.next();
        this.professionItems = new ArrayList<CharString>();
        int piEnd = _run.readLength();
        piEnd += _run.pos();
        while (_run.pos() < piEnd) {
            CharString directoryString = DirectoryString.Factory.createDirectoryString(_run);
            this.professionItems.add(directoryString);
        }
        if (_run.pos() >= end) {
            return;
        }
        tag = _run.get();
        if (tag == 48) {
            _run.next();
            this.professionOIDs = new ArrayList<OBJECTIDENTIFIER>();
            int pOIDsEnd = _run.readLength();
            pOIDsEnd += _run.pos();
            while (_run.pos() < pOIDsEnd) {
                OBJECTIDENTIFIER oid = new OBJECTIDENTIFIER(_run);
                this.professionOIDs.add(oid);
            }
            if (_run.pos() >= end) {
                return;
            }
            tag = _run.get();
        }
        if (tag == 19) {
            this.registrationNumber = new PrintableString(_run);
            if (_run.pos() >= end) {
                return;
            }
            tag = _run.get();
        }
        if (tag == 4) {
            this.addProfessionInfo = new OCTETSTRING(_run);
        }
    }

    public NamingAuthority getNamingAuthority() {
        return this.namingAuthority;
    }

    public List<CharString> getProfessionItems() {
        return this.professionItems;
    }

    public List<OBJECTIDENTIFIER> getProfessionOIDs() {
        if (this.professionOIDs == null) {
            return Collections.emptyList();
        }
        return this.professionOIDs;
    }

    public String getRegistrationNumber() {
        return this.registrationNumber == null ? null : this.registrationNumber.getValue();
    }

    public String getAdditionalInfo() {
        if (this.addProfessionInfo == null) {
            return null;
        }
        return this.addProfessionInfo.toString();
    }

    public OCTETSTRING getAddProfessionInfo() {
        return this.addProfessionInfo;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        Iterator<Object> iter;
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        if (this.namingAuthority != null) {
            this.namingAuthority.dump(w);
            w.newLine();
        }
        if (this.professionItems != null && !this.professionItems.isEmpty()) {
            w.write("professionItems:");
            w.indent();
            w.newLine();
            iter = this.professionItems.iterator();
            while (iter.hasNext()) {
                CharString directoryString = (CharString)iter.next();
                directoryString.dump(w);
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
            w.newLine();
        }
        if (this.professionOIDs != null && !this.professionOIDs.isEmpty()) {
            w.write("professionOIDs:");
            w.indent();
            w.newLine();
            iter = this.professionOIDs.iterator();
            while (iter.hasNext()) {
                OBJECTIDENTIFIER oid = (OBJECTIDENTIFIER)iter.next();
                w.write(oid.toString());
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
            w.newLine();
        }
        if (this.registrationNumber != null) {
            w.write("registrationNumber:");
            w.indent();
            w.newLine();
            w.write(this.registrationNumber.toString());
            w.outdent();
        }
        if (this.addProfessionInfo != null) {
            w.newLine();
            w.write("addProfessionInfo:");
            w.indent();
            w.newLine();
            w.write(this.addProfessionInfo.toString());
            w.outdent();
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        Iterator<Object> iter;
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        result.add(new Flattable.Pair(null, null));
        result.add(new Flattable.Pair(res.getString("profession_info"), ""));
        if (this.namingAuthority != null) {
            result.add(new Flattable.Pair(res.getString("naming_authority"), ""));
            result.addAll(this.namingAuthority.flatten(res, false));
        }
        if (this.professionItems != null && !this.professionItems.isEmpty()) {
            CharString directoryString;
            iter = this.professionItems.iterator();
            if (iter.hasNext()) {
                directoryString = (CharString)iter.next();
                result.add(new Flattable.Pair(res.getString("profession_item"), directoryString.getValue()));
            }
            while (iter.hasNext()) {
                directoryString = (CharString)iter.next();
                result.add(new Flattable.Pair(null, directoryString.getValue()));
            }
        }
        if (this.professionOIDs != null && !this.professionOIDs.isEmpty()) {
            OBJECTIDENTIFIER oid;
            iter = this.professionOIDs.iterator();
            if (iter.hasNext()) {
                oid = (OBJECTIDENTIFIER)iter.next();
                result.add(new Flattable.Pair(res.getString("profession_oid"), oid.getOID()));
            }
            while (iter.hasNext()) {
                oid = (OBJECTIDENTIFIER)iter.next();
                result.add(new Flattable.Pair(null, oid.getOID()));
            }
        }
        if (this.registrationNumber != null) {
            result.add(new Flattable.Pair(res.getString("profession_regNr"), this.registrationNumber.getValue()));
        }
        if (this.addProfessionInfo != null) {
            result.add(new Flattable.Pair(res.getString("addProfessionInfo"), this.addProfessionInfo.toString()));
        }
        return result;
    }
}

