/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.CharString;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.PrintableString;
import de.bos_bremen.ci.asn1.x509.DirectoryString;
import de.bos_bremen.ci.asn1.x509.SigningFor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class ProcurationSyntax
extends ANY
implements Flattable {
    PrintableString country;
    CharString typeOfSubstitution;
    SigningFor signingFor;

    public ProcurationSyntax(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        tag = _run.get();
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 1) {
            _run.next();
            _run.readLength();
            this.country = new PrintableString(_run);
            tag = _run.get();
        }
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 2) {
            _run.next();
            _run.readLength();
            this.typeOfSubstitution = DirectoryString.Factory.createDirectoryString(_run);
            tag = _run.get();
        }
        if (!ASN1.Factory.isTagged(tag) || (tag & 0xF) != 3) {
            throw new ParseException(this, "explicit SigningFor expected", _run.pos());
        }
        _run.next();
        _run.readLength();
        this.signingFor = SigningFor.Factory.generate(_run);
    }

    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        if (this.country != null) {
            w.write("country:");
            w.indent();
            w.newLine();
            this.country.dump(w);
            w.outdent();
            w.newLine();
        }
        if (this.typeOfSubstitution != null) {
            w.write("typeOfSubstitution:");
            w.indent();
            w.newLine();
            this.typeOfSubstitution.dump(w);
            w.outdent();
            w.newLine();
        }
        this.signingFor.dump(w);
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        if (this.country != null) {
            result.add(new Flattable.Pair(res.getString("procuration.country"), this.country.getValue()));
        }
        if (this.typeOfSubstitution != null) {
            result.add(new Flattable.Pair(res.getString("procuration.substitution"), this.typeOfSubstitution.getValue()));
        }
        result.add(new Flattable.Pair(null, null));
        result.add(new Flattable.Pair(res.getString("procuration.substituted_person"), ""));
        result.addAll(this.signingFor.flatten(res, false));
        return result;
    }

    public String getCountry() {
        return this.country == null ? null : this.country.getValue();
    }

    public String getTypeOfSubstitution() {
        return this.typeOfSubstitution == null ? null : this.typeOfSubstitution.getValue();
    }

    public SigningFor getSigningFor() {
        return this.signingFor;
    }
}

