/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.PolicyQualifier;
import de.bos_bremen.ci.asn1.x509.PolicyQualifierId;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyQualifierInfo
extends ANY
implements Dumpable,
Flattable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PolicyQualifierInfo.class);
    PolicyQualifierId policyQualifierId;
    PolicyQualifier qualifier;

    public PolicyQualifierInfo(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.policyQualifierId = new PolicyQualifierId(_run);
        this.qualifier = PolicyQualifierId.tagForOID(this.policyQualifierId, _run);
    }

    public PolicyQualifierId getPolicyQualifierId() {
        return this.policyQualifierId;
    }

    public PolicyQualifier getQualifier() {
        return this.qualifier;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(this.policyQualifierId.toString());
        w.write(32);
        w.write(58);
        w.write(32);
        this.qualifier.dump(w);
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        String value = this.policyQualifierId.getOID();
        try {
            value = res.getString(value);
        }
        catch (MissingResourceException ex) {
            LOGGER.error("Resource not found in given bundle.", (Throwable)ex);
        }
        result.add(new Flattable.Pair(null, value));
        result.addAll(this.qualifier.flatten(res, false));
        return result;
    }
}

