/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.CPSUri;
import de.bos_bremen.ci.asn1.x509.PolicyQualifier;
import de.bos_bremen.ci.asn1.x509.UserNotice;

public class PolicyQualifierId
extends OBJECTIDENTIFIER {
    public static final String id_qt_cps = "1.3.6.1.5.5.7.2.1";
    public static final String id_qt_unotice = "1.3.6.1.5.5.7.2.2";

    public PolicyQualifierId(Run _run) throws ParseException {
        super(_run);
        String oid = this.getOID();
        if (!oid.equals(id_qt_cps) && !oid.equals(id_qt_unotice)) {
            throw new ParseException(this, "expected OIDs \"1.3.6.1.5.5.7.2.1\", \"1.3.6.1.5.5.7.2.2\", but was \"" + oid + "\" at index " + _run.pos(), _run.pos());
        }
    }

    public static PolicyQualifier tagForOID(PolicyQualifierId policyQualifierId, Run _run) throws ParseException {
        String oid = policyQualifierId.getOID();
        if (oid.equals(id_qt_cps)) {
            return new CPSUri(_run);
        }
        if (oid.equals(id_qt_unotice)) {
            return new UserNotice(_run);
        }
        return null;
    }

    public static String nameFor(OBJECTIDENTIFIER _oid) {
        if (id_qt_cps.equals(_oid.getOID())) {
            return "id_qt_cps";
        }
        return "id_qt_unotice";
    }
}

