/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.CertPolicyId;
import de.bos_bremen.ci.asn1.x509.PolicyQualifierInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class PolicyInformation
extends ANY
implements Dumpable,
Flattable {
    CertPolicyId policyIdentifier;
    List<PolicyQualifierInfo> policyQualifiers;

    public PolicyInformation(Run _run) throws ParseException {
        super(_run, false);
        byte b;
        int end;
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int len = _run.readLength();
        boolean indef = len == -1;
        int n = end = indef ? -1 : _run.pos() + len;
        if (!indef) {
            this.setEnd(end);
        }
        this.policyIdentifier = new CertPolicyId(_run);
        this.policyQualifiers = new ArrayList<PolicyQualifierInfo>();
        if (indef && (b = _run.get()) == 0) {
            _run.next();
            _run.next();
            return;
        }
        if (indef || _run.pos() < end) {
            int end2;
            tag = _run.next();
            if (tag != 48) {
                throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
            }
            int len2 = _run.readLength();
            boolean indef2 = len2 == -1;
            int n2 = end2 = indef2 ? -1 : _run.pos() + len2;
            while (indef2 || _run.pos() < end2) {
                byte b2;
                PolicyQualifierInfo pqi = new PolicyQualifierInfo(_run);
                this.policyQualifiers.add(pqi);
                if (!indef2 || (b2 = _run.get()) != 0) continue;
                _run.next();
                _run.next();
                break;
            }
        }
        if (indef && (b = _run.get()) == 0) {
            _run.next();
            _run.next();
        }
    }

    public CertPolicyId getCertPolicyId() {
        return this.policyIdentifier;
    }

    public List<PolicyQualifierInfo> getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(this.policyIdentifier.toString());
        if (this.policyQualifiers != null && !this.policyQualifiers.isEmpty()) {
            w.newLine();
            Iterator<PolicyQualifierInfo> iter = this.policyQualifiers.iterator();
            while (iter.hasNext()) {
                PolicyQualifierInfo pqi = iter.next();
                pqi.dump(w);
                if (!iter.hasNext()) continue;
                w.newLine();
            }
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        String value = this.policyIdentifier.getOID();
        try {
            if (this.policyIdentifier != null) {
                value = res.getString(this.policyIdentifier.getOID());
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        result.add(new Flattable.Pair(res.getString("policyIdentifier"), value));
        if (this.policyQualifiers != null) {
            for (PolicyQualifierInfo pqi : this.policyQualifiers) {
                result.addAll(pqi.flatten(res, false));
            }
        }
        return result;
    }
}

