/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.PSPRole;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class PSPRoles
extends ANY {
    public static final String RB_KEY_ROLES_HEADER = "PaymentServiceProviderRoles";
    List<PSPRole> roles = new ArrayList<PSPRole>();

    public PSPRoles(Run run) throws ParseException {
        super(run, false);
        byte tag = run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + run.pos(), run.pos());
        }
        int end = run.readLength();
        this.setEnd(end += run.pos());
        while (run.pos() < end) {
            this.roles.add(new PSPRole(run));
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String getValueAsString(ResourceBundle rb) {
        StringBuilder sb = new StringBuilder(rb.getString(RB_KEY_ROLES_HEADER));
        sb.append(System.lineSeparator());
        for (int i = 0; i < this.roles.size(); ++i) {
            sb.append(this.roles.get(i).getValueAsString(rb));
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }
}

