/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UTF8String;
import de.bos_bremen.ci.asn1.x509.PSPRole;
import de.bos_bremen.ci.asn1.x509.PSPRoles;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class PSD2Statement
extends ANY
implements Flattable {
    PSPRoles roles;
    UTF8String name;
    UTF8String id;

    public PSD2Statement(Run run) throws ParseException {
        super(run, false);
        byte tag = run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + run.pos(), run.pos());
        }
        this.setEnd(run.pos() + run.readLength());
        this.roles = new PSPRoles(run);
        this.name = new UTF8String(run);
        this.id = new UTF8String(run);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle bundle, boolean brief) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        result.add(new Flattable.Pair(bundle.getString("0.4.0.19495.2"), "0.4.0.19495.2"));
        result.add(new Flattable.Pair(bundle.getString("psd2.ncaname"), this.name.getValueAsString()));
        result.add(new Flattable.Pair(bundle.getString("psd2.ncaid"), this.id.getValueAsString()));
        int cnt = 0;
        for (PSPRole role : this.roles.roles) {
            String keyText = cnt++ == 0 ? bundle.getString("PaymentServiceProviderRoles") : "";
            result.add(new Flattable.Pair(keyText, bundle.getString(role.type.getOID()) + " (" + role.name.getValueAsString() + ") (" + role.type.getOID() + ")"));
        }
        return result;
    }

    public String getValueAsString(ResourceBundle rb) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.roles.getValueAsString(rb));
        sb.append(System.lineSeparator());
        sb.append(rb.getString("psd2.ncaname")).append(": ").append(this.name.getValueAsString());
        sb.append(System.lineSeparator());
        sb.append(rb.getString("psd2.ncaid")).append(": ").append(this.id.getValueAsString());
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

