/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.IA5String;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.PrintableString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class PKIDisclosureStatement
extends ANY
implements Flattable {
    public static final String OID = "0.4.0.1862.1.5";
    Map<PrintableString, IA5String> pkidsMap = new HashMap<PrintableString, IA5String>();

    public PKIDisclosureStatement(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        while (_run.pos() < end) {
            byte innerTag = _run.next();
            if (innerTag != 48) {
                throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
            }
            int innerSeqLen = _run.readLength();
            innerSeqLen += _run.pos();
            IA5String ia5String = new IA5String(_run);
            PrintableString pString = new PrintableString(_run);
            this.pkidsMap.put(pString, ia5String);
        }
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> pairList = new ArrayList<Flattable.Pair>();
        String key = null;
        try {
            key = res.getString(OID);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        for (Map.Entry<PrintableString, IA5String> entry : this.pkidsMap.entrySet()) {
            pairList.add(new Flattable.Pair(key + " (" + entry.getKey().getValueAsString() + ")", entry.getValue().getValueAsString()));
        }
        return pairList;
    }
}

