/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;

public class ObjectDigestInfo
extends ANY {
    public static final int publicKey = 0;
    public static final int publicKeyCert = 1;
    public static final int otherObjectTypes = 2;
    private int digestedObjectType = 0;
    private OBJECTIDENTIFIER otherObjectTypeID;
    private AlgorithmIdentifier digestAlgorithm;
    private BITSTRING digestValue;

    public ObjectDigestInfo(Run _run) throws ParseException {
        this(_run, false);
    }

    public ObjectDigestInfo(Run _run, boolean _implicit) throws ParseException {
        super(_run, _implicit);
        this.load(_run, _implicit);
    }

    public void load(Run _run, boolean _implicit) throws ParseException {
        byte tag = _run.next();
        if (!_implicit && tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos() + ", found: " + Hex.hexify(tag), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.digestedObjectType = _run.get();
        if (this.digestedObjectType != 10) {
            throw new ParseException("ENUMERATED expected at " + (_run.pos() - 1));
        }
        _run.next();
        this.digestedObjectType = _run.next();
        _run.next();
        tag = _run.get();
        if (tag == 6) {
            this.otherObjectTypeID = new OBJECTIDENTIFIER(_run);
            _run.next();
        }
        if (tag != 48) {
            throw new ParseException("SEQUENCE of AlgorithmIdentifier expected at " + (_run.pos() - 1));
        }
        this.digestAlgorithm = new AlgorithmIdentifier(_run);
        this.digestValue = new BITSTRING(_run);
    }
}

