/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.IOException;

public class ORAddress
extends ANY
implements Dumpable {
    public ORAddress(Run run) throws ParseException {
        this(run, false);
    }

    public ORAddress(Run run, boolean implicit) throws ParseException {
        super(run, implicit);
        byte tag = run.next();
        if (!implicit && tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + run.pos(), run.pos());
        }
        run.skip(run.readLength());
        this.setEnd(run.pos());
    }

    @Override
    public String getValueAsString() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        return source.asHexedString(run.pos(), len);
    }

    @Override
    public String toString() {
        return "ORAddress[" + this.getValueAsString() + "]";
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        w.write(this.toString());
    }
}

