/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.CharString;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.DisplayText;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class NoticeReference
extends ANY
implements Dumpable,
Flattable {
    CharString organization;
    List<INTEGER> noticeNumbers;

    public NoticeReference(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.organization = DisplayText.Factory.createDisplayText(_run);
        tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        this.noticeNumbers = new ArrayList<INTEGER>();
        end = _run.readLength();
        end += _run.pos();
        while (_run.pos() < end) {
            INTEGER noticeNumber = new INTEGER(_run);
            this.noticeNumbers.add(noticeNumber);
        }
    }

    public String getOrganization() {
        return this.organization.getValue();
    }

    public List<Integer> getNoticeNumbers() {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (INTEGER i : this.noticeNumbers) {
            result.add(i.getValue().intValue());
        }
        return result;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        if (this.organization != null) {
            this.organization.dump(w);
        }
        if (!this.noticeNumbers.isEmpty()) {
            w.indent();
            if (this.organization != null) {
                w.newLine();
            }
            Iterator<INTEGER> iter = this.noticeNumbers.iterator();
            while (iter.hasNext()) {
                INTEGER noticeNumber = iter.next();
                w.write(noticeNumber.toString());
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        if (this.organization != null) {
            result.add(new Flattable.Pair(res.getString("organisation"), this.organization.getValue()));
        }
        StringBuilder sb = new StringBuilder();
        Iterator<INTEGER> iter = this.noticeNumbers.iterator();
        while (iter.hasNext()) {
            INTEGER noticeNumber = iter.next();
            sb.append(noticeNumber.getValue().toString());
            if (!iter.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        result.add(new Flattable.Pair(res.getString("noticereference.number"), sb.toString()));
        return result;
    }
}

