/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.CharString;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.IA5String;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.DirectoryString;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class NamingAuthority
extends ANY
implements Dumpable,
Flattable {
    OBJECTIDENTIFIER id;
    IA5String url;
    CharString name;

    public NamingAuthority(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)49) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        tag = _run.get();
        if (tag == 6) {
            this.id = new OBJECTIDENTIFIER(_run);
            tag = _run.get();
        }
        if (tag == 22) {
            this.url = new IA5String(_run);
            tag = _run.get();
        }
        if (tag == 12) {
            this.name = DirectoryString.Factory.createDirectoryString(_run);
        }
    }

    public OBJECTIDENTIFIER getID() {
        return this.id;
    }

    public String getName() {
        return this.name.getValue();
    }

    public String getURI() {
        return this.url.getValue();
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        if (this.id != null) {
            w.write(this.id.toString());
        }
        if (this.url != null) {
            w.write(this.url.toString());
        }
        if (this.name != null) {
            w.write(this.name.toString());
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        if (this.id != null) {
            result.add(new Flattable.Pair(res.getString("naming_authority.id"), this.id.getOID()));
        }
        if (this.url != null) {
            result.add(new Flattable.Pair(res.getString("naming_authority.url"), this.url.getValue()));
        }
        if (this.name != null) {
            result.add(new Flattable.Pair(res.getString("naming_authority.name"), this.name.getValue()));
        }
        return result;
    }
}

