/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AttributeTypeAndValue;
import de.bos_bremen.ci.asn1.x509.Name;
import de.bos_bremen.ci.asn1.x509.NameConstants;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class NameUtil
implements NameConstants {
    static final Map<String, OBJECTIDENTIFIER> KNOWN_OID = new HashMap<String, OBJECTIDENTIFIER>();
    static final Map<String, String> SHORTCUTS = new HashMap<String, String>();
    private static final Properties ABBREVIATIONS;

    static String getAbbreviation(OBJECTIDENTIFIER oid) {
        return ABBREVIATIONS.getProperty(oid.getOID() + ".abbr", oid.getOID());
    }

    static boolean isUnescapedDoubleQuote(String dn, int pos) {
        return dn.charAt(pos) == '\"' && NameUtil.isUnescaped(dn, pos);
    }

    static int jumptToQuotationEnd(String dn, int pos) throws ParseException {
        do {
            if (++pos < dn.length()) continue;
            throw new ParseException(dn, "Non-closing quotation", pos);
        } while (!NameUtil.isUnescapedDoubleQuote(dn, pos));
        return pos;
    }

    static boolean isUnescapedRDNSeparator(String dn, int pos) {
        return dn.charAt(pos) == ',' && NameUtil.isUnescaped(dn, pos);
    }

    static boolean isUnescaped(String dn, int pos) {
        return pos <= 0 || dn.charAt(pos - 1) != '\\';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Comparator<AttributeTypeAndValue> getComparator() {
        final HashMap<String, Integer> order = new HashMap<String, Integer>();
        try {
            InputStream is = Name.class.getResourceAsStream("Name.order");
            LineNumberReader r = new LineNumberReader(new InputStreamReader(is));
            try {
                String line = r.readLine();
                int n = 0;
                while (line != null) {
                    int index = line.indexOf(61);
                    if (index != -1) {
                        order.put(line.substring(0, index), n++);
                    }
                    line = r.readLine();
                }
            }
            finally {
                try {
                    r.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new Comparator<AttributeTypeAndValue>(){

            @Override
            public int compare(AttributeTypeAndValue o1, AttributeTypeAndValue o2) {
                Integer i2;
                Integer i1 = (Integer)order.get(o1.type.getOID());
                if (i1 == null) {
                    i1 = Integer.MAX_VALUE;
                }
                if ((i2 = (Integer)order.get(o2.type.getOID())) == null) {
                    i2 = Integer.MAX_VALUE;
                }
                return i1.compareTo(i2);
            }
        };
    }

    static boolean needsEscaping(char c) {
        return c == ',' || c == '+' || c == '\"' || c == '\\' || c == '<' || c == '>' || c == ';';
    }

    public static String escapeRFC2253(String valueAsString) {
        StringBuilder sb = new StringBuilder();
        int count = valueAsString.length();
        for (int i = 0; i < count; ++i) {
            char c = valueAsString.charAt(i);
            if (i == 0 && c == ' ' || NameUtil.needsEscaping(c)) {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (NameUtil.isControlCharacter(c)) {
                sb.append('\\');
                String hex = Integer.toHexString(c).toUpperCase(Locale.GERMAN);
                if (hex.length() % 2 == 1) {
                    sb.append('0');
                }
                sb.append(hex);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static boolean isControlCharacter(char c) {
        return c >= '\u0000' && c <= '\u001f';
    }

    static {
        KNOWN_OID.put("UID", UID);
        KNOWN_OID.put("DC", DC);
        KNOWN_OID.put("EMAILADDRESS", EMAILADDRESS);
        KNOWN_OID.put("E", E);
        KNOWN_OID.put("CN", CN);
        KNOWN_OID.put("SURNAME", SURNAME);
        KNOWN_OID.put("SN", SN);
        KNOWN_OID.put("SERIALNUMBER", SN);
        KNOWN_OID.put("C", C);
        KNOWN_OID.put("L", L);
        KNOWN_OID.put("ST", ST);
        KNOWN_OID.put("STREET", STREET);
        KNOWN_OID.put("O", O);
        KNOWN_OID.put("OU", OU);
        KNOWN_OID.put("T", T);
        KNOWN_OID.put("DESCRIPTION", DESCRIPTION);
        KNOWN_OID.put("SH", SH);
        KNOWN_OID.put("BRANCHE", BRANCHE);
        KNOWN_OID.put("POSTALADDRESS", POSTALADDRESS);
        KNOWN_OID.put("ZC", PLZ);
        KNOWN_OID.put("POBOX", POBOX);
        KNOWN_OID.put("PhysicalDeliveryOfficeName", PhysicalDeliveryOfficeName);
        KNOWN_OID.put("TEL", TEL);
        KNOWN_OID.put("FAX", Fax);
        KNOWN_OID.put("NAME", Name);
        KNOWN_OID.put("GIVENNAME", GIVENNAME);
        KNOWN_OID.put("INITIALS", INITIALS);
        KNOWN_OID.put("GENERATION", GENERATION);
        KNOWN_OID.put("PN", Pseudonym);
        KNOWN_OID.put("dateOfBirth", DATE_OF_BIRTH);
        KNOWN_OID.put("placeOfBirth", PLACE_OF_BIRTH);
        KNOWN_OID.put("gender", GENDER);
        KNOWN_OID.put("countryOfCitizenship", COUNTRY_OF_CITIZENSHIP);
        KNOWN_OID.put("countryOfResidence", COUNTRY_OF_RESIDENCE);
        KNOWN_OID.put("nameDistinguisher", NAME_DISTINGUISHER);
        KNOWN_OID.put(UID.getOID(), UID);
        KNOWN_OID.put(DC.getOID(), DC);
        KNOWN_OID.put(EMAILADDRESS.getOID(), EMAILADDRESS);
        KNOWN_OID.put(E.getOID(), E);
        KNOWN_OID.put(CN.getOID(), CN);
        KNOWN_OID.put(SURNAME.getOID(), SURNAME);
        KNOWN_OID.put(SN.getOID(), SN);
        KNOWN_OID.put(C.getOID(), C);
        KNOWN_OID.put(L.getOID(), L);
        KNOWN_OID.put(ST.getOID(), ST);
        KNOWN_OID.put(STREET.getOID(), STREET);
        KNOWN_OID.put(O.getOID(), O);
        KNOWN_OID.put(OU.getOID(), OU);
        KNOWN_OID.put(T.getOID(), T);
        KNOWN_OID.put(DESCRIPTION.getOID(), DESCRIPTION);
        KNOWN_OID.put(SH.getOID(), SH);
        KNOWN_OID.put(BRANCHE.getOID(), BRANCHE);
        KNOWN_OID.put(POSTALADDRESS.getOID(), POSTALADDRESS);
        KNOWN_OID.put(PLZ.getOID(), PLZ);
        KNOWN_OID.put(POBOX.getOID(), POBOX);
        KNOWN_OID.put(PhysicalDeliveryOfficeName.getOID(), PhysicalDeliveryOfficeName);
        KNOWN_OID.put(TEL.getOID(), TEL);
        KNOWN_OID.put(Fax.getOID(), Fax);
        KNOWN_OID.put(Name.getOID(), Name);
        KNOWN_OID.put(GIVENNAME.getOID(), GIVENNAME);
        KNOWN_OID.put(INITIALS.getOID(), INITIALS);
        KNOWN_OID.put(GENERATION.getOID(), GENERATION);
        KNOWN_OID.put(Pseudonym.getOID(), Pseudonym);
        KNOWN_OID.put(DATE_OF_BIRTH.getOID(), DATE_OF_BIRTH);
        KNOWN_OID.put(PLACE_OF_BIRTH.getOID(), PLACE_OF_BIRTH);
        KNOWN_OID.put(GENDER.getOID(), GENDER);
        KNOWN_OID.put(COUNTRY_OF_CITIZENSHIP.getOID(), COUNTRY_OF_CITIZENSHIP);
        KNOWN_OID.put(COUNTRY_OF_RESIDENCE.getOID(), COUNTRY_OF_RESIDENCE);
        KNOWN_OID.put(NAME_DISTINGUISHER.getOID(), NAME_DISTINGUISHER);
        SHORTCUTS.put(UID.getOID(), "UID");
        SHORTCUTS.put(DC.getOID(), "DC");
        SHORTCUTS.put(EMAILADDRESS.getOID(), "EMAILADDRESS");
        SHORTCUTS.put(E.getOID(), "E");
        SHORTCUTS.put(CN.getOID(), "CN");
        SHORTCUTS.put(SURNAME.getOID(), "SURNAME");
        SHORTCUTS.put(SN.getOID(), "SN");
        SHORTCUTS.put(C.getOID(), "C");
        SHORTCUTS.put(L.getOID(), "L");
        SHORTCUTS.put(ST.getOID(), "ST");
        SHORTCUTS.put(STREET.getOID(), "STREET");
        SHORTCUTS.put(O.getOID(), "O");
        SHORTCUTS.put(OU.getOID(), "OU");
        SHORTCUTS.put(T.getOID(), "T");
        SHORTCUTS.put(DESCRIPTION.getOID(), "DESCRIPTION");
        SHORTCUTS.put(SH.getOID(), "SH");
        SHORTCUTS.put(BRANCHE.getOID(), "BRANCHE");
        SHORTCUTS.put(POSTALADDRESS.getOID(), "POSTALADDRESS");
        SHORTCUTS.put(PLZ.getOID(), "ZC");
        SHORTCUTS.put(POBOX.getOID(), "POBOX");
        SHORTCUTS.put(PhysicalDeliveryOfficeName.getOID(), "PhysicalDeliveryOfficeName");
        SHORTCUTS.put(TEL.getOID(), "TEL");
        SHORTCUTS.put(Fax.getOID(), "FAX");
        SHORTCUTS.put(Name.getOID(), "NAME");
        SHORTCUTS.put(GIVENNAME.getOID(), "GIVENNAME");
        SHORTCUTS.put(INITIALS.getOID(), "INITIALS");
        SHORTCUTS.put(GENERATION.getOID(), "GENERATION");
        SHORTCUTS.put(Pseudonym.getOID(), "PN");
        SHORTCUTS.put(DATE_OF_BIRTH.getOID(), "dateOfBirth");
        SHORTCUTS.put(PLACE_OF_BIRTH.getOID(), "placeOfBirth");
        SHORTCUTS.put(GENDER.getOID(), "gender");
        SHORTCUTS.put(COUNTRY_OF_CITIZENSHIP.getOID(), "citizenship");
        SHORTCUTS.put(COUNTRY_OF_RESIDENCE.getOID(), "residence");
        SHORTCUTS.put(NAME_DISTINGUISHER.getOID(), "nameDistinguisher");
        ABBREVIATIONS = new Properties();
        try {
            String s = Name.class.getName();
            s = s.replace('.', '/');
            ABBREVIATIONS.load(Name.class.getResourceAsStream("/" + s + ".abbr"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

