/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.FlattableUtil;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AbstractString;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.BOOLEAN;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.NULL;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.Time;
import de.bos_bremen.ci.asn1.x509.AdmissionAuthority;
import de.bos_bremen.ci.asn1.x509.AttributeTypeAndValue;
import de.bos_bremen.ci.asn1.x509.GeneralName;
import de.bos_bremen.ci.asn1.x509.NameConstants;
import de.bos_bremen.ci.asn1.x509.NameUtil;
import de.bos_bremen.ci.asn1.x509.RelativeDistinguishedName;
import de.bos_bremen.ci.asn1.x509.RelativeDistinguishedNameMatcher;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Name
extends ANY
implements GeneralName,
Principal,
NameConstants,
AdmissionAuthority {
    List<RelativeDistinguishedName> relativeDistinguishedNames;
    private String serialized;

    public static final synchronized Map<String, OBJECTIDENTIFIER> getKnownOIDs() {
        return NameUtil.KNOWN_OID;
    }

    public static final synchronized String getShortcutFor(OBJECTIDENTIFIER _oid) {
        return NameUtil.SHORTCUTS.get(_oid.getOID());
    }

    public Name(byte[] _bytes, boolean _implicit) throws ParseException {
        this(Run.create(new BSource(_bytes)), _implicit);
    }

    public Name(Run _run) throws ParseException {
        this(_run, false);
    }

    public Name(Run _run, boolean _implicit) throws ParseException {
        super(_run, _implicit);
        byte tag = _run.next();
        if (!_implicit && tag != 48 && tag != 49) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.relativeDistinguishedNames = new ArrayList<RelativeDistinguishedName>();
        while (_run.pos() < end) {
            RelativeDistinguishedName relativeDistinguishedName = new RelativeDistinguishedName(_run);
            this.relativeDistinguishedNames.add(relativeDistinguishedName);
        }
    }

    public List<RelativeDistinguishedName> getRelativeDistinguishedNames() {
        return this.relativeDistinguishedNames;
    }

    @Deprecated
    public Name() {
        this.relativeDistinguishedNames = new ArrayList<RelativeDistinguishedName>();
    }

    public Name(String dn) throws ParseException {
        String rdn;
        int end;
        this.relativeDistinguishedNames = new ArrayList<RelativeDistinguishedName>();
        if (dn == null) {
            throw new NullPointerException("passed null");
        }
        int offset = 0;
        for (end = 0; end < dn.length(); ++end) {
            if (NameUtil.isUnescapedDoubleQuote(dn, end)) {
                end = NameUtil.jumptToQuotationEnd(dn, end);
                continue;
            }
            if (!NameUtil.isUnescapedRDNSeparator(dn, end)) continue;
            rdn = dn.substring(offset, end);
            this.relativeDistinguishedNames.add(new RelativeDistinguishedName(rdn));
            offset = end + 1;
        }
        if (end > offset) {
            rdn = dn.substring(offset);
            this.relativeDistinguishedNames.add(new RelativeDistinguishedName(rdn));
        }
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (this.relativeDistinguishedNames != null && !this.relativeDistinguishedNames.isEmpty()) {
            w.indent();
            w.newLine();
            Iterator<RelativeDistinguishedName> iter = this.relativeDistinguishedNames.iterator();
            while (iter.hasNext()) {
                RelativeDistinguishedName relativeDistinguishedName = iter.next();
                relativeDistinguishedName.dump(w);
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    public String getCommonName() {
        RelativeDistinguishedNameMatcher matcher = new RelativeDistinguishedNameMatcher(CN);
        List<String> cns = matcher.getMatches(this);
        if (!cns.isEmpty()) {
            return cns.get(0);
        }
        matcher = new RelativeDistinguishedNameMatcher(Name);
        List<String> names = matcher.getMatches(this);
        if (!names.isEmpty()) {
            return names.get(0);
        }
        return null;
    }

    public String getOrganisation() {
        RelativeDistinguishedNameMatcher matcher = new RelativeDistinguishedNameMatcher(O);
        List<String> orgs = matcher.getMatches(this);
        if (!orgs.isEmpty()) {
            return orgs.get(0);
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        String commonName = this.getCommonName();
        if (commonName != null && commonName.length() != 0) {
            return commonName;
        }
        return this.getOrganisation();
    }

    public String getCountry() {
        RelativeDistinguishedNameMatcher matcher = new RelativeDistinguishedNameMatcher(C);
        List<String> countries = matcher.getMatches(this);
        if (!countries.isEmpty()) {
            return countries.get(0);
        }
        return null;
    }

    public String getOrganisationUnit() {
        RelativeDistinguishedNameMatcher matcher = new RelativeDistinguishedNameMatcher(OU);
        List<String> orgUnits = matcher.getMatches(this);
        Collections.sort(orgUnits);
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = orgUnits.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(',');
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        if (this.relativeDistinguishedNames == null) {
            return result;
        }
        ArrayList<AttributeTypeAndValue> entries = new ArrayList<AttributeTypeAndValue>();
        for (RelativeDistinguishedName relativeDistinguishedName : this.relativeDistinguishedNames) {
            for (AttributeTypeAndValue entry2 : relativeDistinguishedName.attributeTypeAndValues) {
                entries.add(entry2);
            }
        }
        Collections.sort(entries, NameUtil.getComparator());
        for (AttributeTypeAndValue entry : entries) {
            String value;
            Object cs;
            String key = entry.type.getOID();
            try {
                key = res.getString(key);
            }
            catch (MissingResourceException entry2) {
                // empty catch block
            }
            if (entry.value instanceof AbstractString) {
                cs = (AbstractString)entry.value;
                value = ((AbstractString)cs).getValue();
            } else if (entry.value instanceof Time) {
                cs = (Time)((Object)entry.value);
                DateFormat sdf = FlattableUtil.newDateFormat(res, _short);
                value = sdf.format(cs.getDate());
            } else {
                value = entry.value.getValueAsString();
            }
            result.add(new Flattable.Pair(key, value));
        }
        return result;
    }

    public static synchronized Comparator<AttributeTypeAndValue> getComparator() {
        return NameUtil.getComparator();
    }

    public boolean matches(Name other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        ArrayList<AttributeTypeAndValue> otherATVs = new ArrayList<AttributeTypeAndValue>();
        for (RelativeDistinguishedName rdn : other.getRelativeDistinguishedNames()) {
            otherATVs.addAll(rdn.getAttributeTypeAndValuesSet());
        }
        for (RelativeDistinguishedName rdn : this.relativeDistinguishedNames) {
            for (AttributeTypeAndValue atv : rdn.getAttributeTypeAndValuesSet()) {
                if (otherATVs.remove(atv)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == null || !(o instanceof Name)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        Name other = (Name)o;
        return this.getName().equals(other.getName());
    }

    @Override
    public String getName() {
        return this.getAsDirectoryString();
    }

    public String getAsDirectoryString() {
        if (this.serialized == null) {
            this.serialize();
        }
        return this.serialized;
    }

    private void serialize() {
        StringBuilder sb = new StringBuilder();
        if (this.relativeDistinguishedNames != null) {
            Iterator<RelativeDistinguishedName> iter = this.relativeDistinguishedNames.iterator();
            while (iter.hasNext()) {
                RelativeDistinguishedName relativeDistinguishedName = iter.next();
                sb.append(relativeDistinguishedName.getAsDirectoryString());
                if (!iter.hasNext()) continue;
                sb.append(',');
            }
        }
        this.serialized = sb.toString();
    }

    public static String escapeRFC2253(String valueAsString) {
        return NameUtil.escapeRFC2253(valueAsString);
    }

    public void addRelativeDistinguishedName(OBJECTIDENTIFIER oid, ANY value) {
        this.serialized = null;
        RelativeDistinguishedName relativeDistinguishedName = new RelativeDistinguishedName(oid, value);
        this.relativeDistinguishedNames.add(relativeDistinguishedName);
    }

    public void addRelativeDistinguishedName(int index, OBJECTIDENTIFIER oid, ANY value) {
        this.serialized = null;
        RelativeDistinguishedName relativeDistinguishedName = this.relativeDistinguishedNames.get(index);
        relativeDistinguishedName.addAttributeTypeAndValue(new AttributeTypeAndValue(oid, value));
    }

    public byte[] encode() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.encode(os);
        return os.toByteArray();
    }

    @Override
    public void encode(OutputStream os) throws IOException {
        os.write(49);
        int length = 0;
        for (RelativeDistinguishedName rdn : this.relativeDistinguishedNames) {
            length += rdn.getLength();
        }
        INTEGER.writeLength(os, length);
        for (RelativeDistinguishedName rdn : this.relativeDistinguishedNames) {
            rdn.encode(os);
        }
    }

    @Deprecated
    public static ANY generate(Run _run) throws ParseException {
        byte tag = _run.get();
        switch (tag) {
            case 3: {
                return new BITSTRING(_run);
            }
            case 1: {
                return new BOOLEAN(_run);
            }
            case 2: {
                return new INTEGER(_run);
            }
            case 5: {
                return new NULL(_run);
            }
            case 6: {
                return new OBJECTIDENTIFIER(_run);
            }
            case 4: {
                return new OCTETSTRING(_run);
            }
        }
        return AbstractString.generate(_run);
    }

    @Deprecated
    public static boolean isHexDigit(int c) {
        if (c >= 48 && c <= 57) {
            return true;
        }
        if (c >= 97 && c <= 102) {
            return true;
        }
        return c >= 65 && c <= 70;
    }

    @Override
    public String getAsString() {
        return this.getAsDirectoryString();
    }
}

