/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.PrintableString;
import de.bos_bremen.ci.asn1.x509.MonetaryUtil;
import de.bos_bremen.ci.asn1.x509.StatementValue;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class MonetaryValue
extends ANY
implements StatementValue,
Dumpable,
Flattable {
    public static final String OID = "0.4.0.1862.1.2";
    PrintableString currencyAsString;
    INTEGER currencyAsINTEGER;
    INTEGER amount;
    INTEGER exponent;

    public MonetaryValue(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        tag = _run.get();
        if (tag == 19) {
            this.currencyAsString = new PrintableString(_run);
        } else {
            this.currencyAsINTEGER = new INTEGER(_run);
        }
        this.amount = new INTEGER(_run);
        this.exponent = new INTEGER(_run);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(MonetaryUtil.display(this, false));
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public String getValue() {
        return MonetaryUtil.display(this, true);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        return Arrays.asList(this.getPair(res));
    }

    @Override
    public Flattable.Pair getPair(ResourceBundle res) {
        return new Flattable.Pair(res.getString("qcMonetaryLimit"), this.getValue());
    }

    @Override
    public String getText() {
        return this.getValue();
    }

    public PrintableString getCurrencyAsString() {
        return this.currencyAsString;
    }

    public INTEGER getCurrencyAsINTEGER() {
        return this.currencyAsINTEGER;
    }

    public INTEGER getAmount() {
        return this.amount;
    }

    public INTEGER getExponent() {
        return this.exponent;
    }
}

