/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.asn1.x509.ISO4217Handler;
import de.bos_bremen.ci.asn1.x509.MonetaryLimitSyntax;
import de.bos_bremen.ci.asn1.x509.MonetaryValue;
import java.math.BigInteger;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class MonetaryUtil {
    private static Map<Integer, String> currencyCode;

    public static String display(MonetaryLimitSyntax monetaryLimitSyntax, boolean shortForm) {
        BigInteger am = monetaryLimitSyntax.getAmount().getValue();
        BigInteger ex = monetaryLimitSyntax.getExponent().getValue();
        String currency = monetaryLimitSyntax.getCurrency().getValue();
        return MonetaryUtil.displayStringFor(am, ex, currency, shortForm);
    }

    public static String display(MonetaryValue monetaryValue, boolean shortForm) {
        BigInteger am = monetaryValue.getAmount().getValue();
        BigInteger ex = monetaryValue.getExponent().getValue();
        String currency = null;
        currency = monetaryValue.getCurrencyAsINTEGER() != null ? monetaryValue.getCurrencyAsINTEGER().getValue().toString() : monetaryValue.getCurrencyAsString().getValue();
        currency = MonetaryUtil.getCurrencyName(currency);
        return MonetaryUtil.displayStringFor(am, ex, currency, shortForm);
    }

    private static String displayStringFor(BigInteger am, BigInteger ex, String currency, boolean shortForm) {
        StringBuilder sb = new StringBuilder();
        if (!shortForm) {
            sb.append(am.toString());
            sb.append(" * 10^");
            sb.append(ex.toString());
            sb.append(" = ");
        }
        BigInteger bi = am.multiply(new BigInteger("10").pow(ex.intValue()));
        sb.append(bi.toString());
        sb.append(' ');
        sb.append(currency);
        String displayString = sb.toString();
        return displayString;
    }

    public static String getCurrencyName(String numericCode) {
        try {
            int intCode = Integer.parseInt(numericCode);
            if (currencyCode == null) {
                currencyCode = MonetaryUtil.loadCurrencyTable();
            }
            if (currencyCode.containsKey(intCode)) {
                return currencyCode.get(intCode);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return numericCode;
    }

    protected static Map<Integer, String> loadCurrencyTable() {
        try {
            XMLReader reader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
            ISO4217Handler iso4217Handler = new ISO4217Handler();
            reader.setContentHandler(iso4217Handler);
            reader.parse(new InputSource(MonetaryUtil.class.getResourceAsStream("ISO4217.xml")));
            return iso4217Handler.map;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot read currenty file", e);
        }
    }
}

