/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.PrintableString;
import de.bos_bremen.ci.asn1.x509.MonetaryUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class MonetaryLimitSyntax
extends ANY
implements Flattable,
Dumpable {
    PrintableString currency;
    INTEGER amount;
    INTEGER exponent;

    public MonetaryLimitSyntax(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.currency = new PrintableString(_run);
        this.amount = new INTEGER(_run);
        this.exponent = new INTEGER(_run);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write(MonetaryUtil.display(this, false));
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        return Arrays.asList(new Flattable.Pair(null, this.getValueAsString()));
    }

    @Override
    public String getValueAsString() {
        return MonetaryUtil.display(this, true);
    }

    public PrintableString getCurrency() {
        return this.currency;
    }

    public INTEGER getAmount() {
        return this.amount;
    }

    public INTEGER getExponent() {
        return this.exponent;
    }
}

