/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.IOException;

public class KeyUsage
extends BITSTRING
implements Dumpable {
    public static final int flagcount = 9;
    public static final int digitalSignature = 0;
    public static final int nonRepudiation = 1;
    public static final int keyEncipherment = 2;
    public static final int dataEncipherment = 3;
    public static final int keyAgreement = 4;
    public static final int keyCertSign = 5;
    public static final int crlSign = 6;
    public static final int encipherOnly = 7;
    public static final int decipherOnly = 8;

    public KeyUsage(Run _run) throws ParseException {
        super(_run);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        w.write(this.toString());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("KeyUsage[");
        boolean b = false;
        for (int i = 0; i < 9; ++i) {
            if (!this.is(i)) continue;
            if (b) {
                sb.append(',');
                sb.append(' ');
            }
            sb.append(KeyUsage.toString(i));
            b = true;
        }
        sb.append(']');
        return sb.toString();
    }

    @Override
    public boolean[] getValue() {
        Source source = this.getSource();
        Run run = Run.create(source, this.getOffset() + 1);
        int len = run.readLength();
        run.next();
        int k = 0;
        boolean[] result = new boolean[Math.max(9, --len * 8)];
        while (run.pos() < this.getEnd()) {
            byte b = run.next();
            int j = 0;
            while (j < 8) {
                result[k * 8 + j++] = (b & 0x80) == 128;
                b = (byte)(b << 1);
            }
            ++k;
        }
        return result;
    }

    public static String toString(int flag) {
        switch (flag) {
            case 0: {
                return "digitalSignature";
            }
            case 1: {
                return "nonRepudiation";
            }
            case 2: {
                return "keyEncipherment";
            }
            case 3: {
                return "dataEncipherment";
            }
            case 4: {
                return "keyAgreement";
            }
            case 5: {
                return "keyCertSign";
            }
            case 6: {
                return "crlSign";
            }
            case 7: {
                return "encipherOnly";
            }
            case 8: {
                return "decipherOnly";
            }
        }
        return "unknown flag \"" + flag + "\"";
    }

    public static String toString(boolean[] _uk) {
        StringBuilder sb = new StringBuilder();
        for (boolean b : _uk) {
            sb.append(b ? (char)'1' : '0');
        }
        return sb.toString();
    }
}

