/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.Extension;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.TBSCertificate;
import de.bos_bremen.ci.asn1.x509.ext.BasicConstraintsExtension;
import de.bos_bremen.ci.asn1.x509.ext.KeyUsageExtension;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class JX509Certificate
extends X509Certificate {
    private final Certificate delegate;

    public JX509Certificate(Certificate _delegate) {
        this.delegate = _delegate;
    }

    public Certificate getDelegate() {
        return this.delegate;
    }

    @Override
    public byte[] getEncoded() {
        Run run = Run.create(this.delegate.getSource(), this.delegate.getOffset());
        return run.next(this.delegate.getLength());
    }

    @Override
    public PublicKey getPublicKey() {
        return this.delegate.getTBSCertificate().getSubjectPublicKeyInfo().getPublicKey();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(key, (String)null);
    }

    @Override
    public void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature v = null;
        v = sigProvider == null ? Signature.getInstance(this.delegate.getSignatureAlgorithm().getJCAName()) : Signature.getInstance(this.delegate.getSignatureAlgorithm().getAlgorithmName(), sigProvider);
        v.initVerify(key);
        if (!this.delegate.getSignatureAlgorithm().getAlgorithmName().equals(this.delegate.getTBSCertificate().getSignature().getAlgorithmName())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        v.update(this.delegate.getTBSCertificate().asByteArray());
        if (!v.verify(this.delegate.getSignature().getValueAsByteArray())) {
            throw new SignatureException();
        }
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.before(this.getNotBefore())) {
            throw new CertificateNotYetValidException();
        }
        if (date.after(this.getNotAfter())) {
            throw new CertificateExpiredException();
        }
    }

    @Override
    public int getBasicConstraints() {
        Extensions exts = this.delegate.getExtensions();
        if (exts == null) {
            return -1;
        }
        BasicConstraintsExtension e = (BasicConstraintsExtension)exts.get("2.5.29.19");
        if (e == null) {
            return -1;
        }
        return e.getPathLenConstraint();
    }

    @Override
    public Principal getIssuerDN() {
        return this.delegate.getIssuer();
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        if (this.delegate.getTBSCertificate().getIssuerUniqueID() == null) {
            return null;
        }
        return this.delegate.getTBSCertificate().getIssuerUniqueID().getValueAsBooleanArray();
    }

    @Override
    public boolean[] getKeyUsage() {
        Extensions exts = this.delegate.getExtensions();
        if (exts == null) {
            return null;
        }
        KeyUsageExtension e = (KeyUsageExtension)exts.get("2.5.29.15");
        if (e == null) {
            return null;
        }
        return e.getKeyUsage().getValue();
    }

    @Override
    public Date getNotAfter() {
        return this.delegate.getNotAfter();
    }

    @Override
    public Date getNotBefore() {
        return this.delegate.getNotBefore();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.delegate.getSerialNumber().getValue();
    }

    @Override
    public String getSigAlgName() {
        return this.delegate.getTBSCertificate().getSignature().getAlgorithmName();
    }

    @Override
    public String getSigAlgOID() {
        return this.delegate.getTBSCertificate().getSignature().getOID().getOID();
    }

    @Override
    public byte[] getSigAlgParams() {
        ANY parameters = this.delegate.getTBSCertificate().getSignature().getParameters();
        Run run = Run.create(parameters.getSource(), parameters.getOffset());
        return run.next(parameters.getLength());
    }

    @Override
    public byte[] getSignature() {
        return this.delegate.getSignature().getValueAsByteArray();
    }

    @Override
    public Principal getSubjectDN() {
        return this.delegate.getSubject();
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        if (this.delegate.getTBSCertificate().getSubjectUniqueID() == null) {
            return null;
        }
        return this.delegate.getTBSCertificate().getSubjectUniqueID().getValueAsBooleanArray();
    }

    @Override
    public byte[] getTBSCertificate() {
        TBSCertificate tbs = this.delegate.getTBSCertificate();
        Run run = Run.create(tbs.getSource(), tbs.getOffset());
        return run.next(tbs.getLength());
    }

    @Override
    public int getVersion() {
        return this.delegate.getTBSCertificate().getVersion().getValue().intValue();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        Extensions exts = this.delegate.getExtensions();
        if (exts == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Extension e : exts.getExtensions()) {
            if (!e.isCritical()) continue;
            result.add(e.getOID());
        }
        return result;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        Extensions exts = this.delegate.getExtensions();
        if (exts == null) {
            return null;
        }
        Extension e = exts.get(oid);
        if (e == null) {
            return null;
        }
        OCTETSTRING octets = e.getOctets();
        Run run = Run.create(octets.getSource(), octets.getOffset());
        return run.next(octets.getLength());
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        Extensions exts = this.delegate.getExtensions();
        if (exts == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Extension e : exts.getExtensions()) {
            if (e.isCritical()) continue;
            result.add(e.getOID());
        }
        return result;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        return new X500Principal(this.delegate.getSubject().asByteArray());
    }

    public static JX509Certificate forX509(X509Certificate c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JX509Certificate) {
            return (JX509Certificate)c;
        }
        try {
            return new JX509Certificate(Certificate.forX509(c));
        }
        catch (Throwable ex) {
            return null;
        }
    }
}

