/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.crl.RevokedCertificate;
import de.bos_bremen.ci.asn1.x509.Extension;
import de.bos_bremen.ci.asn1.x509.Extensions;
import java.math.BigInteger;
import java.security.cert.CRLException;
import java.security.cert.X509CRLEntry;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class JX509CRLEntry
extends X509CRLEntry {
    private final RevokedCertificate delegate;

    public JX509CRLEntry(RevokedCertificate _delegate) {
        this.delegate = _delegate;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        return this.delegate.getEncoded();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.delegate.getUserCertificateSerialNumbner().getValue();
    }

    @Override
    public Date getRevocationDate() {
        return this.delegate.getRevocationDate().getDate();
    }

    @Override
    public boolean hasExtensions() {
        Extensions extensions = this.delegate.getCRLEntryExtensions();
        return extensions != null && !extensions.isEmpty();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        Extensions exts = this.delegate.getCRLEntryExtensions();
        if (exts == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Extension e : exts.getExtensions()) {
            if (!e.isCritical()) continue;
            result.add(e.getOID());
        }
        return result;
    }

    @Override
    public byte[] getExtensionValue(String _oid) {
        Extensions exts = this.delegate.getCRLEntryExtensions();
        if (exts == null) {
            return null;
        }
        Extension e = exts.get(_oid);
        if (e == null) {
            return null;
        }
        OCTETSTRING octets = e.getOctets();
        Run run = Run.create(octets.getSource(), octets.getOffset());
        return run.next(octets.getLength());
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        Extensions exts = this.delegate.getCRLEntryExtensions();
        if (exts == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Extension e : exts.getExtensions()) {
            if (e.isCritical()) continue;
            result.add(e.getOID());
        }
        return result;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }
}

