/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.OCTETSTRING;
import de.bos_bremen.ci.asn1.Time;
import de.bos_bremen.ci.asn1.crl.CertificateList;
import de.bos_bremen.ci.asn1.crl.RevokedCertificate;
import de.bos_bremen.ci.asn1.x509.Extension;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.JX509CRLEntry;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

public class JX509CRL
extends X509CRL {
    private final CertificateList delegate;

    public JX509CRL(CertificateList _delegate) {
        this.delegate = _delegate;
    }

    @Override
    public byte[] getEncoded() throws CRLException {
        return this.delegate.getEncoded();
    }

    @Override
    public void verify(PublicKey _key) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(_key, (String)null);
    }

    @Override
    public void verify(PublicKey _key, String _sigProvider) throws CRLException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (!this.delegate.verify(_key, _sigProvider)) {
            throw new SignatureException();
        }
    }

    @Override
    public int getVersion() {
        return this.delegate.getTBSCertList().getVersion().getValue().intValue();
    }

    @Override
    public Principal getIssuerDN() {
        return new X500Principal(this.delegate.getTBSCertList().getIssuer().asByteArray());
    }

    @Override
    public Date getThisUpdate() {
        return this.delegate.getTBSCertList().getThisUpdate().getDate();
    }

    @Override
    public Date getNextUpdate() {
        Time nextUpdate = this.delegate.getTBSCertList().getNextUpdate();
        return nextUpdate == null ? null : nextUpdate.getDate();
    }

    @Override
    public X509CRLEntry getRevokedCertificate(BigInteger _serialNumber) {
        List<RevokedCertificate> revokedCertificates = this.delegate.getTBSCertList().getRevokedCertificates();
        for (RevokedCertificate revokedCertificate : revokedCertificates) {
            BigInteger serialNumber = revokedCertificate.getUserCertificateSerialNumbner().getValue();
            if (!serialNumber.equals(_serialNumber)) continue;
            return new JX509CRLEntry(revokedCertificate);
        }
        return null;
    }

    @Override
    public Set<? extends X509CRLEntry> getRevokedCertificates() {
        HashSet<JX509CRLEntry> result = new HashSet<JX509CRLEntry>();
        List<RevokedCertificate> revokedCertificates = this.delegate.getTBSCertList().getRevokedCertificates();
        for (RevokedCertificate revokedCertificate : revokedCertificates) {
            result.add(new JX509CRLEntry(revokedCertificate));
        }
        return result;
    }

    @Override
    public byte[] getTBSCertList() throws CRLException {
        return this.delegate.getTBSCertList().asByteArray();
    }

    @Override
    public byte[] getSignature() {
        return this.delegate.getSignatureValue().asByteArray();
    }

    @Override
    public String getSigAlgName() {
        return this.delegate.getSignatureAlgorithm().getAlgorithmName();
    }

    @Override
    public String getSigAlgOID() {
        return this.delegate.getSignatureAlgorithm().getOID().getOID();
    }

    @Override
    public byte[] getSigAlgParams() {
        return this.delegate.getSignatureAlgorithm().getParameters().asByteArray();
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public boolean isRevoked(Certificate _cert) {
        FlatCertificate fc;
        try {
            fc = FlatCertificate.Factory.forX509(_cert);
        }
        catch (Exception ex) {
            return false;
        }
        BigInteger serialNumber = fc.getSerialNumber().getValue();
        List<RevokedCertificate> revokedCertificates = this.delegate.getTBSCertList().getRevokedCertificates();
        for (RevokedCertificate revokedCertificate : revokedCertificates) {
            BigInteger value = revokedCertificate.getUserCertificateSerialNumbner().getValue();
            if (!serialNumber.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getCriticalExtensionOIDs() {
        Extensions exts = this.delegate.getTBSCertList().getCrlExtensions();
        if (exts == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Extension e : exts.getExtensions()) {
            if (!e.isCritical()) continue;
            result.add(e.getOID());
        }
        return result;
    }

    @Override
    public byte[] getExtensionValue(String _oid) {
        Extensions exts = this.delegate.getTBSCertList().getCrlExtensions();
        if (exts == null) {
            return null;
        }
        Extension e = exts.get(_oid);
        if (e == null) {
            return null;
        }
        OCTETSTRING octets = e.getOctets();
        Run run = Run.create(octets.getSource(), octets.getOffset());
        return run.next(octets.getLength());
    }

    @Override
    public Set<String> getNonCriticalExtensionOIDs() {
        Extensions exts = this.delegate.getTBSCertList().getCrlExtensions();
        if (exts == null) {
            return Collections.emptySet();
        }
        HashSet<String> result = new HashSet<String>();
        for (Extension e : exts.getExtensions()) {
            if (e.isCritical()) continue;
            result.add(e.getOID());
        }
        return result;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        return false;
    }
}

