/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.asn1.x509.AttributeCertificate;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;

public final class JCertificate
extends java.security.cert.Certificate {
    private final transient FlatCertificate delegate;

    public JCertificate(FlatCertificate _delegate) {
        super("X509");
        this.delegate = _delegate;
    }

    public FlatCertificate getDelegate() {
        return this.delegate;
    }

    @Override
    public byte[] getEncoded() {
        return this.delegate.getEncoded();
    }

    @Override
    public PublicKey getPublicKey() {
        if (this.delegate instanceof Certificate) {
            Certificate c = (Certificate)this.delegate;
            return c.getTBSCertificate().getSubjectPublicKeyInfo().getPublicKey();
        }
        return null;
    }

    @Override
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public void verify(PublicKey _key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(_key, (String)null);
    }

    @Override
    public void verify(PublicKey _key, String _sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        if (this.delegate instanceof AttributeCertificate) {
            AttributeCertificate ac = (AttributeCertificate)this.delegate;
            Signature sig = Signature.getInstance(ac.signatureAlgorithm.getJCAName());
            sig.initVerify(_key);
            sig.update(ac.getAttributeCertificateInfo().asByteArray());
            if (!sig.verify(ac.getSignature().getValueAsByteArray())) {
                throw new SignatureException();
            }
            return;
        }
        Certificate c = (Certificate)this.delegate;
        Signature v = null;
        v = _sigProvider == null ? Signature.getInstance(c.getSignatureAlgorithm().getJCAName()) : Signature.getInstance(c.getSignatureAlgorithm().getJCAName(), _sigProvider);
        v.initVerify(_key);
        if (!c.getSignatureAlgorithm().getAlgorithmName().equals(c.getTBSCertificate().getSignature().getAlgorithmName())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        v.update(c.getTBSCertificate().asByteArray());
        if (!v.verify(c.getSignature().getValueAsByteArray())) {
            throw new SignatureException();
        }
    }
}

