/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.BOOLEAN;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.DistributionPointName;
import de.bos_bremen.ci.asn1.x509.ReasonFlags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class IssuingDistPointSyntax
extends ANY
implements Flattable {
    DistributionPointName distributionPoint;
    BOOLEAN onlyContainsUserCerts;
    BOOLEAN onlyContainsCACerts;
    ReasonFlags onlySomeReasons;
    BOOLEAN indirectCRL;

    public IssuingDistPointSyntax(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.get();
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 0) {
            this.distributionPoint = DistributionPointName.Factory.generate(_run);
        }
        this.onlyContainsUserCerts = ASN1.Factory.isTagged(tag) && (tag & 0xF) == 1 ? new BOOLEAN(_run) : BOOLEAN.FALSE;
        this.onlyContainsCACerts = ASN1.Factory.isTagged(tag) && (tag & 0xF) == 2 ? new BOOLEAN(_run) : BOOLEAN.FALSE;
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 3) {
            this.onlySomeReasons = new ReasonFlags(_run);
        }
        this.indirectCRL = ASN1.Factory.isTagged(tag) && (tag & 0xF) == 4 ? new BOOLEAN(_run) : BOOLEAN.FALSE;
        this.setEnd(_run.pos());
    }

    public void dump(DumpWriter w) throws IOException {
        if (this.distributionPoint != null) {
            w.newLine();
            this.distributionPoint.dump(w);
        }
        w.newLine();
        w.write("onlyContainsUserCerts: " + this.onlyContainsUserCerts);
        w.newLine();
        w.write("onlyContainsCACerts: " + this.onlyContainsCACerts);
        if (this.onlySomeReasons != null) {
            w.newLine();
            w.write("onlySomeReasons : " + this.onlySomeReasons.getValueAsString());
        }
        w.newLine();
        w.write("indirectCRL: " + this.indirectCRL);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        if (this.distributionPoint != null) {
            result.addAll(this.distributionPoint.flatten(res, _short));
        }
        result.add(new Flattable.Pair(null, res.getString("onlyContainsUserCerts." + (this.onlyContainsUserCerts.getValue() ? "yes" : "no"))));
        result.add(new Flattable.Pair(null, res.getString("onlyContainsCACerts." + (this.onlyContainsCACerts.getValue() ? "yes" : "no"))));
        if (this.onlySomeReasons != null) {
            result.add(new Flattable.Pair(res.getString("onlySomeReasons"), this.onlySomeReasons.toString()));
        }
        return result;
    }
}

