/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.INTEGER;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.GeneralName;
import de.bos_bremen.ci.asn1.x509.GeneralNames;
import de.bos_bremen.ci.asn1.x509.Name;
import de.bos_bremen.ci.asn1.x509.SigningFor;
import de.bos_bremen.ci.asn1.x509.Subject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class IssuerSerial
extends ANY
implements SigningFor,
Dumpable,
Subject {
    GeneralNames issuer;
    INTEGER serial;
    BITSTRING issuerUID;

    public IssuerSerial(Run _run, boolean implicit) throws ParseException {
        super(_run, implicit);
        byte tag = _run.next();
        if (!implicit && tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.issuer = new GeneralNames(_run);
        this.serial = new INTEGER(_run);
        if (_run.pos() < end) {
            this.issuerUID = new BITSTRING(_run);
        }
    }

    public IssuerSerial(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.issuer = new GeneralNames(_run);
        this.serial = new INTEGER(_run);
        if (_run.pos() < end) {
            this.issuerUID = new BITSTRING(_run);
        }
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        this.issuer.dump(w);
        w.newLine();
        w.write("serial : ");
        w.write(this.serial.toString());
        if (this.issuerUID != null) {
            w.newLine();
            w.write("issuerUID : ");
            w.write(this.issuerUID.toString());
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        for (GeneralName generalName : this.issuer.generalNames) {
            result.addAll(generalName.flatten(res, false));
        }
        result.add(new Flattable.Pair(res.getString("issuerserial.serial"), this.serial.getValue().toString()));
        if (this.issuerUID != null) {
            result.add(new Flattable.Pair(res.getString("issuerserial.issueruid"), this.issuerUID.toString()));
        }
        return result;
    }

    @Override
    public String getDisplayName() {
        return this.issuer.getName().getOrganisation();
    }

    @Override
    public boolean matches(FlatCertificate _userCertificate) {
        Name ucIssuer = _userCertificate.getIssuer();
        if (!this.issuer.get(0).equals(ucIssuer)) {
            return false;
        }
        return this.serial.getValue().equals(_userCertificate.getSerialNumber().getValue());
    }

    @Override
    public Name getName() {
        return (Name)this.issuer.get(0);
    }

    public GeneralNames getIssuer() {
        return this.issuer;
    }

    public BITSTRING getIssuerUID() {
        return this.issuerUID;
    }

    public INTEGER getSerialnumber() {
        return this.serial;
    }
}

