/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import java.util.HashMap;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class ISO4217Handler
extends DefaultHandler {
    Map<Integer, String> map = new HashMap<Integer, String>();
    private StringBuffer sb = null;
    private Integer numericCode;
    private String alphabeticCode;

    ISO4217Handler() {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) {
        this.sb = qName.equals("ALPHABETIC_CODE") || qName.equals("NUMERIC_CODE") ? new StringBuffer() : null;
    }

    @Override
    public void characters(char[] ch, int start, int len) {
        if (this.sb != null) {
            this.sb.append(ch, start, len);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("ALPHABETIC_CODE")) {
            this.alphabeticCode = this.sb.toString();
        } else if (qName.equals("NUMERIC_CODE")) {
            try {
                this.numericCode = Integer.valueOf(this.sb.toString());
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (qName.equals("ISO_CURRENCY")) {
            if (this.numericCode != null && this.alphabeticCode != null) {
                this.map.put(this.numericCode, this.alphabeticCode);
            }
            this.numericCode = null;
            this.alphabeticCode = null;
        }
    }
}

