/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.GeneralNames;
import de.bos_bremen.ci.asn1.x509.IssuerSerial;
import de.bos_bremen.ci.asn1.x509.Name;
import de.bos_bremen.ci.asn1.x509.ObjectDigestInfo;
import de.bos_bremen.ci.asn1.x509.Subject;
import java.io.IOException;
import java.util.List;
import java.util.ResourceBundle;

public class Holder
extends ANY
implements Subject {
    private IssuerSerial issuerSerial;
    private GeneralNames entityName;
    private ObjectDigestInfo objectDigestInfo;

    public Holder(Run _run) throws ParseException {
        super(_run, false);
        int l;
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = l = _run.readLength();
        this.setEnd(end += _run.pos());
        tag = _run.get();
        if (!ASN1.Factory.isTagged(tag)) {
            throw new RuntimeException("");
        }
        if (_run.pos() >= end) {
            return;
        }
        if (ASN1.Factory.isTaggedAs(tag, 0)) {
            this.issuerSerial = new IssuerSerial(_run, true);
            tag = _run.get();
        }
        if (_run.pos() >= end) {
            return;
        }
        if (ASN1.Factory.isTaggedAs(tag, 1)) {
            this.entityName = new GeneralNames(_run, true);
            tag = _run.get();
        }
        if (_run.pos() >= end) {
            return;
        }
        if (ASN1.Factory.isTaggedAs(tag, 2)) {
            this.objectDigestInfo = new ObjectDigestInfo(_run, true);
            tag = _run.get();
        }
    }

    public IssuerSerial getIssuerSerial() {
        return this.issuerSerial;
    }

    public GeneralNames getEntityName() {
        return this.entityName;
    }

    public Object getObjectDigestInfo() {
        return this.objectDigestInfo;
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        Subject subject = this.getSubject();
        if (subject != null) {
            subject.dump(w);
        }
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle bundle, boolean onlyShortList) {
        Subject subject = this.getSubject();
        if (subject != null) {
            return subject.flatten(bundle, onlyShortList);
        }
        return null;
    }

    private Subject getSubject() {
        if (this.issuerSerial != null) {
            return this.issuerSerial;
        }
        if (this.entityName != null) {
            return this.entityName;
        }
        return null;
    }

    @Override
    public String getDisplayName() {
        Subject subject = this.getSubject();
        if (subject != null) {
            return subject.getDisplayName();
        }
        return null;
    }

    @Override
    public boolean matches(FlatCertificate _userCertificate) {
        Subject subject = this.getSubject();
        if (subject != null) {
            return subject.matches(_userCertificate);
        }
        return false;
    }

    @Override
    public Name getName() {
        Subject subject = this.getSubject();
        if (subject != null) {
            return subject.getName();
        }
        return null;
    }
}

