/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.GeneralSubtree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class GeneralSubtrees
extends ANY
implements Dumpable {
    List<GeneralSubtree> subtrees;

    public GeneralSubtrees(Run _run) throws ParseException {
        super(_run, false);
        _run.next();
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.subtrees = new ArrayList<GeneralSubtree>();
        while (_run.pos() < end) {
            GeneralSubtree subtree = new GeneralSubtree(_run);
            this.subtrees.add(subtree);
        }
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (!this.subtrees.isEmpty()) {
            w.indent();
            w.newLine();
            Iterator<GeneralSubtree> iter = this.subtrees.iterator();
            while (iter.hasNext()) {
                GeneralSubtree subtree = iter.next();
                subtree.dump(w);
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    public Collection<GeneralSubtree> getSubtrees() {
        return this.subtrees;
    }
}

