/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.BaseDistance;
import de.bos_bremen.ci.asn1.x509.GeneralName;
import java.io.IOException;

public class GeneralSubtree
extends ANY
implements Dumpable {
    GeneralName base;
    BaseDistance minimum;
    BaseDistance maximum;

    public GeneralSubtree(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        this.base = GeneralName.Factory.generate(_run);
        this.minimum = new BaseDistance(0);
        if (_run.pos() >= end) {
            return;
        }
        tag = _run.get();
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 0) {
            this.minimum = new BaseDistance(_run);
            if (_run.pos() >= end) {
                return;
            }
            tag = _run.get();
        }
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 0) {
            this.maximum = new BaseDistance(_run);
        }
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        this.base.dump(w);
        w.newLine();
        w.write("min : ");
        w.write(this.minimum.toString());
        if (this.maximum != null) {
            w.newLine();
            w.write(this.maximum.toString());
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    public GeneralName getBase() {
        return this.base;
    }

    public int getMinimum() {
        return this.minimum == null ? -1 : this.minimum.getValue().intValue();
    }

    public int getMaximum() {
        return this.maximum == null ? -1 : this.maximum.getValue().intValue();
    }
}

