/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.DistributionPointName;
import de.bos_bremen.ci.asn1.x509.FlatCertificate;
import de.bos_bremen.ci.asn1.x509.GeneralName;
import de.bos_bremen.ci.asn1.x509.Name;
import de.bos_bremen.ci.asn1.x509.Subject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;

public class GeneralNames
extends ANY
implements Subject,
DistributionPointName {
    List<GeneralName> generalNames;

    public GeneralNames(Run _run) throws ParseException {
        this(_run, false);
    }

    public GeneralNames(Run _run, boolean _implicit) throws ParseException {
        super(_run, _implicit);
        this.load(_run, _implicit);
    }

    public void load(Run _run, boolean _implicit) throws ParseException {
        this.generalNames = new ArrayList<GeneralName>();
        byte tag = _run.next();
        if (!_implicit && tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos() + ", found: " + Hex.hexify(tag), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        while (_run.pos() < end) {
            GeneralName generalName = GeneralName.Factory.generate(_run, true);
            this.generalNames.add(generalName);
        }
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (!this.generalNames.isEmpty()) {
            w.indent();
            w.newLine();
            Iterator<GeneralName> iter = this.generalNames.iterator();
            while (iter.hasNext()) {
                GeneralName generalName = iter.next();
                generalName.dump(w);
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    public Collection<GeneralName> getGeneralNames() {
        return this.generalNames;
    }

    public GeneralName get(int _index) {
        return this.generalNames.get(_index);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        for (GeneralName generalName : this.generalNames) {
            result.addAll(generalName.flatten(res, false));
        }
        return result;
    }

    @Override
    public String getDisplayName() {
        return this.getName().getOrganisation();
    }

    @Override
    public Name getName() {
        Name generalName = (Name)this.generalNames.get(0);
        return generalName;
    }

    @Override
    public boolean matches(FlatCertificate _userCertificate) {
        Name acIsser = (Name)this.get(0);
        Name issuer = _userCertificate.getIssuer();
        return acIsser.matches(issuer);
    }
}

