/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.DNSName;
import de.bos_bremen.ci.asn1.x509.DistributionPointName;
import de.bos_bremen.ci.asn1.x509.EdiPartyName;
import de.bos_bremen.ci.asn1.x509.IPAddress;
import de.bos_bremen.ci.asn1.x509.Name;
import de.bos_bremen.ci.asn1.x509.OtherName;
import de.bos_bremen.ci.asn1.x509.RFC822Name;
import de.bos_bremen.ci.asn1.x509.RegisteredID;
import de.bos_bremen.ci.asn1.x509.SigningFor;
import de.bos_bremen.ci.asn1.x509.UniformResourceIdentifier;
import de.bos_bremen.ci.asn1.x509.X400Address;

public interface GeneralName
extends SigningFor,
DistributionPointName {
    public static final int OTHERNAME = 0;
    public static final int RFC822NAME = 1;
    public static final int DNSNAME = 2;
    public static final int X400ADDRESS = 3;
    public static final int DIRECTORYNAME = 4;
    public static final int EDIPARTYNAME = 5;
    public static final int UNIFORMRESOURCEIDENTIFIER = 6;
    public static final int IPADDRESS = 7;
    public static final int REGISTEREDID = 8;

    public String getDisplayName();

    public static final class Factory {
        public static final GeneralName generate(Run _run) throws ParseException {
            return Factory.generate(_run, false);
        }

        public static final GeneralName generate(Run _run, boolean _implicit) throws ParseException {
            byte tag = _run.get();
            if (!_implicit || ASN1.Factory.getTagNumber(tag) == 4) {
                _run.next();
                _run.readLength();
            }
            switch (ASN1.Factory.getTagNumber(tag)) {
                case 0: {
                    return new OtherName(_run, true);
                }
                case 1: {
                    return new RFC822Name(_run, true);
                }
                case 2: {
                    return new DNSName(_run, true);
                }
                case 3: {
                    return new X400Address(_run, true);
                }
                case 4: {
                    return new Name(_run, false);
                }
                case 5: {
                    return new EdiPartyName(_run, true);
                }
                case 6: {
                    return new UniformResourceIdentifier(_run, true);
                }
                case 7: {
                    return new IPAddress(_run, true);
                }
                case 8: {
                    return new RegisteredID(_run, true);
                }
            }
            ANY any = new ANY(_run, true);
            throw new ParseException(any, "no representation for choice \"" + Hex.hexify(tag) + "\" at index " + _run.pos(), _run.pos());
        }
    }
}

