/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AbstractFlattableDumpablePublicKey;
import de.bos_bremen.ci.asn1.x509.DSAPublicKey;
import de.bos_bremen.ci.asn1.x509.RSAPublicKey;
import de.bos_bremen.ci.asn1.x509.SubjectPublicKeyInfo;
import de.bos_bremen.ci.asn1.x509.ec.ECPublicKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlattableDumpablePublicKeyFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FlattableDumpablePublicKeyFactory.class);

    public static AbstractFlattableDumpablePublicKey createKey(SubjectPublicKeyInfo keyInfo) {
        String cipherAlgoName = keyInfo.getAlgorithm();
        try {
            if ("RSA".equals(cipherAlgoName)) {
                return new RSAPublicKey(keyInfo);
            }
            if ("DSA".equals(cipherAlgoName)) {
                return new DSAPublicKey(keyInfo);
            }
            if ("EC".equals(cipherAlgoName)) {
                return new ECPublicKey(keyInfo);
            }
        }
        catch (ParseException e) {
            LOGGER.error("Cannot parse key info.", (Throwable)e);
        }
        return null;
    }
}

