/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.BSource;
import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.QLevel;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.AlgorithmIdentifier;
import de.bos_bremen.ci.asn1.BITSTRING;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.AttributeCertificate;
import de.bos_bremen.ci.asn1.x509.Certificate;
import de.bos_bremen.ci.asn1.x509.CertificateSerialNumber;
import de.bos_bremen.ci.asn1.x509.Extensions;
import de.bos_bremen.ci.asn1.x509.JCertificate;
import de.bos_bremen.ci.asn1.x509.Name;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertificateEncodingException;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public interface FlatCertificate
extends Flattable,
Dumpable {
    public byte[] getFingerprint(String var1);

    public String getHexedFingerprint(String var1);

    public String getHexedFingerprint(String var1, boolean var2);

    public Name getSubject();

    public Name getIssuer();

    public String getSubjectCommonName();

    public String getIssuerCommonName();

    public Date getNotAfter();

    public Date getNotBefore();

    public Date getGenerationTime();

    public Source getSource();

    public Extensions getExtensions();

    public CertificateSerialNumber getSerialNumber();

    public boolean hasCommonPKIrestrictions();

    @Deprecated
    public QLevel getQLevel();

    public byte[] getEncoded();

    public int getOffset();

    public int getLength();

    public long remainingDaysValid(Date var1);

    public AlgorithmIdentifier getSignatureAlgorithm();

    public BITSTRING getSignature();

    public List<Flattable.Pair> getOverviewPairs(ResourceBundle var1, boolean var2);

    public static final class Factory {
        private static final String PEM_HEADER = "-----BEGIN CERTIFICATE-----";
        private static final String PEM_FOOTER = "-----END CERTIFICATE-----";

        private Factory() {
        }

        public static ResourceBundle res(Locale locale) {
            return ResourceBundle.getBundle(Flattable.class.getName(), locale);
        }

        public static ResourceBundle res() {
            return Factory.res(Locale.getDefault());
        }

        public static final FlatCertificate generate(InputStream source) throws ParseException {
            try {
                return Factory.generate(new BSource(source));
            }
            catch (IOException e) {
                throw new ParseException(e.getMessage());
            }
        }

        public static final FlatCertificate generate(Source source) throws ParseException {
            try {
                return new Certificate(source);
            }
            catch (ParseException ex) {
                return new AttributeCertificate(source);
            }
        }

        public static final boolean isPEMEncoded(Source source) {
            try {
                Factory.decodePEM(source);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        public static final Source decodePEM(Source source) {
            String s = source.toCharBuffer("UTF-8").toString().trim();
            if (!s.startsWith(PEM_HEADER)) {
                throw new IllegalArgumentException("PEM header missing");
            }
            if (!(s = s.substring(PEM_HEADER.length())).endsWith(PEM_FOOTER)) {
                throw new IllegalArgumentException("PEM footer missing");
            }
            s = s.substring(0, s.length() - PEM_FOOTER.length());
            s = Factory.cleanString(s);
            byte[] bytes = Base64.getDecoder().decode(s);
            return new BSource(bytes);
        }

        public static final boolean isBase64Encoded(Source source) {
            try {
                Factory.decodeBase64(source);
                return true;
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }

        public static final Source decodeBase64(Source source) {
            String cleanString = Factory.cleanString(source.toCharBuffer("UTF-8").toString());
            byte[] bytes = Base64.getDecoder().decode(cleanString);
            return new BSource(bytes);
        }

        public static final FlatCertificate generateCertificate(Run run) throws ParseException {
            return new Certificate(run);
        }

        public static final FlatCertificate generateAttributeCertificate(Run run) throws ParseException {
            return new AttributeCertificate(run);
        }

        public static final FlatCertificate generateCertificateSet(Run run) throws ParseException {
            byte tag = run.get();
            if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 0) {
                throw new UnsupportedOperationException("ExtendedCertificate not supported");
            }
            if (ASN1.Factory.isTagged(tag) && ((tag & 0xF) == 1 || (tag & 0xF) == 2)) {
                return new AttributeCertificate(run, true);
            }
            return new Certificate(run);
        }

        public static final FlatCertificate forX509(java.security.cert.Certificate c) throws ParseException, CertificateEncodingException {
            if (c instanceof JCertificate) {
                return ((JCertificate)c).getDelegate();
            }
            return Factory.generate(new BSource(c.getEncoded()));
        }

        private static final String cleanString(String str) {
            return str.trim().replaceAll("[\n\r]", "");
        }
    }
}

