/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class FieldID
extends ANY
implements Dumpable,
Flattable {
    OBJECTIDENTIFIER fieldType;
    ANY parameters;

    public FieldID(Run run) throws ParseException {
        super(run, false);
        byte tag = run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + run.pos(), run.pos());
        }
        int end = run.readLength();
        this.setEnd(end += run.pos());
        this.fieldType = new OBJECTIDENTIFIER(run);
        this.parameters = ASN1.Factory.generate(run);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        w.write("fieldType: " + this.fieldType.getOID());
        w.newLine();
        w.write("parameters: " + this.parameters.getValueAsHexedString());
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        result.add(new Flattable.Pair(res.getString("general.publickey.ec.ecparameters.field.type"), this.fieldType.getOID()));
        if (Flattable.class.isInstance(this.parameters)) {
            result.addAll(((Flattable)Flattable.class.cast(this.parameters)).flatten(res, _short));
        } else {
            result.add(new Flattable.Pair(res.getString("general.publickey.ec.ecparameters.field.parameters"), this.parameters.getValueAsHexedString()));
        }
        return result;
    }
}

