/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.Extension;
import de.bos_bremen.ci.asn1.x509.ExtensionFactory;
import de.bos_bremen.ci.asn1.x509.ext.UnprocessedExtension;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;

public class Extensions
extends ANY
implements Dumpable,
Flattable {
    private Map<String, Extension> extensions;

    public Extensions() {
        this.extensions = new HashMap<String, Extension>();
    }

    public Extensions(Run _run) throws ParseException {
        this(_run, false);
    }

    public Extensions(Run _run, boolean _implicit) throws ParseException {
        super(_run, _implicit);
        this.load(_run, _implicit);
    }

    public void load(Run _run, boolean _implicit) throws ParseException {
        this.extensions = new HashMap<String, Extension>();
        byte tag = _run.next();
        if (!_implicit && tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        while (_run.pos() < end) {
            UnprocessedExtension extension = new UnprocessedExtension(_run);
            this.extensions.put(extension.getOID(), extension);
        }
    }

    public boolean contains(String oid) {
        return this.extensions.get(oid) != null;
    }

    public <T extends Extension> T get(Class<T> extensionClass, String oid) {
        if (extensionClass == null) {
            return null;
        }
        Extension extension = null;
        try {
            extension = this.get(oid);
        }
        catch (Throwable e) {
            return null;
        }
        if (extensionClass.isInstance(extension)) {
            return (T)((Extension)extensionClass.cast(extension));
        }
        return null;
    }

    public Extension get(String oid) {
        Extension extension = this.extensions.get(oid);
        if (extension == null) {
            return null;
        }
        try {
            Extension e = ExtensionFactory.forOID(extension);
            if (e == null) {
                System.out.println("UNKNOWN: " + extension.getOID());
            } else {
                e.load();
            }
            return e;
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public void put(String _oid, Extension _extension) {
        this.extensions.put(_oid, _extension);
    }

    public boolean isEmpty() {
        return this.extensions.isEmpty();
    }

    public Collection<Extension> getExtensions() {
        ArrayList<Extension> result = new ArrayList<Extension>();
        for (Map.Entry<String, Extension> entry : this.extensions.entrySet()) {
            Extension extension = entry.getValue();
            try {
                Extension e = ExtensionFactory.forOID(extension);
                e.load();
                result.add(e);
            }
            catch (ParseException ex) {
                System.err.println(ex.toString());
            }
        }
        return result;
    }

    public Iterator<Extension> iterator() {
        return this.getExtensions().iterator();
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        if (!this.extensions.isEmpty()) {
            w.indent();
            w.newLine();
            Iterator<Extension> iter = this.getExtensions().iterator();
            while (iter.hasNext()) {
                Extension extension = iter.next();
                extension.dump(w);
                if (!iter.hasNext()) continue;
                w.newLine();
            }
            w.outdent();
        }
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        if (this.extensions.isEmpty()) {
            return pairs;
        }
        pairs.add(new Flattable.Pair(res.getString("extensions"), null));
        List exts = (List)this.getExtensions();
        Collections.sort(exts, ExtensionFactory.getComparator());
        Iterator iter = exts.iterator();
        while (iter.hasNext()) {
            Extension ext = (Extension)iter.next();
            pairs.addAll(ext.flatten(res, false));
            if (!iter.hasNext()) continue;
            pairs.add(new Flattable.Pair(null, null));
        }
        return pairs;
    }
}

