/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.Source;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.x509.Extension;
import de.bos_bremen.ci.asn1.x509.ext.AdditionalInformationExtension;
import de.bos_bremen.ci.asn1.x509.ext.AdmissionExtension;
import de.bos_bremen.ci.asn1.x509.ext.AuthorityInfoAccessExtension;
import de.bos_bremen.ci.asn1.x509.ext.AuthorityKeyIdentifierExtension;
import de.bos_bremen.ci.asn1.x509.ext.BasicConstraintsExtension;
import de.bos_bremen.ci.asn1.x509.ext.CRLDistributionPointsExtension;
import de.bos_bremen.ci.asn1.x509.ext.CRLNumberExtension;
import de.bos_bremen.ci.asn1.x509.ext.CRLReasonExtension;
import de.bos_bremen.ci.asn1.x509.ext.CertGenerationDateExtension;
import de.bos_bremen.ci.asn1.x509.ext.CertHashExtension;
import de.bos_bremen.ci.asn1.x509.ext.CertificateIssuerExtension;
import de.bos_bremen.ci.asn1.x509.ext.CertificatePoliciesExtension;
import de.bos_bremen.ci.asn1.x509.ext.DeclarationOfMajorityExtension;
import de.bos_bremen.ci.asn1.x509.ext.ExtendedKeyUsageExtension;
import de.bos_bremen.ci.asn1.x509.ext.ICCSNExtension;
import de.bos_bremen.ci.asn1.x509.ext.IssuerAltNamesExtension;
import de.bos_bremen.ci.asn1.x509.ext.IssuingDistributionPointExtension;
import de.bos_bremen.ci.asn1.x509.ext.KeyUsageExtension;
import de.bos_bremen.ci.asn1.x509.ext.LiabilityLimitationFlagExtension;
import de.bos_bremen.ci.asn1.x509.ext.MonetaryLimitExtension;
import de.bos_bremen.ci.asn1.x509.ext.NameConstraintsExtension;
import de.bos_bremen.ci.asn1.x509.ext.NetscapeCertificateTypeExtension;
import de.bos_bremen.ci.asn1.x509.ext.OCSPNoCheckExtension;
import de.bos_bremen.ci.asn1.x509.ext.PolicyConstraintsExtension;
import de.bos_bremen.ci.asn1.x509.ext.PolicyMappingsExtension;
import de.bos_bremen.ci.asn1.x509.ext.ProcurationExtension;
import de.bos_bremen.ci.asn1.x509.ext.QCStatementsExtension;
import de.bos_bremen.ci.asn1.x509.ext.RestrictionExtension;
import de.bos_bremen.ci.asn1.x509.ext.SubjectAltNamesExtension;
import de.bos_bremen.ci.asn1.x509.ext.SubjectDirectoryAttributesExtension;
import de.bos_bremen.ci.asn1.x509.ext.SubjectKeyIdentifierExtension;
import de.bos_bremen.ci.asn1.x509.ext.UnprocessedExtension;
import de.bos_bremen.ci.asn1.x509.ext.ValidityModelExtension;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class ExtensionFactory {
    private static final Map<String, Class<? extends Extension>> oidImplementations = new HashMap<String, Class<? extends Extension>>();
    private static ExtComparator extOrderer;
    private static ExtComparator commonPKIExtOrderer;

    private static synchronized Map<String, Class<? extends Extension>> getOIDImplementations() {
        if (oidImplementations.isEmpty()) {
            oidImplementations.put("1.3.36.8.3.3", AdmissionExtension.class);
            oidImplementations.put("2.5.29.19", BasicConstraintsExtension.class);
            oidImplementations.put("2.5.29.31", CRLDistributionPointsExtension.class);
            oidImplementations.put("1.3.36.8.3.5", DeclarationOfMajorityExtension.class);
            oidImplementations.put("2.5.29.18", IssuerAltNamesExtension.class);
            oidImplementations.put("2.5.29.15", KeyUsageExtension.class);
            oidImplementations.put("1.3.36.8.3.4", MonetaryLimitExtension.class);
            oidImplementations.put("2.5.29.30", NameConstraintsExtension.class);
            oidImplementations.put("1.3.36.8.3.2", ProcurationExtension.class);
            oidImplementations.put("2.5.29.17", SubjectAltNamesExtension.class);
            oidImplementations.put("2.5.29.9", SubjectDirectoryAttributesExtension.class);
            oidImplementations.put("2.5.29.14", SubjectKeyIdentifierExtension.class);
            oidImplementations.put("2.5.29.32", CertificatePoliciesExtension.class);
            oidImplementations.put("2.5.29.33", PolicyMappingsExtension.class);
            oidImplementations.put("2.5.29.35", AuthorityKeyIdentifierExtension.class);
            oidImplementations.put("2.5.29.36", PolicyConstraintsExtension.class);
            oidImplementations.put("2.5.29.37", ExtendedKeyUsageExtension.class);
            oidImplementations.put("1.3.6.1.5.5.7.1.1", AuthorityInfoAccessExtension.class);
            oidImplementations.put("1.3.6.1.5.5.7.1.3", QCStatementsExtension.class);
            oidImplementations.put("1.3.36.8.3.15", AdditionalInformationExtension.class);
            oidImplementations.put("1.3.36.8.3.8", RestrictionExtension.class);
            oidImplementations.put("0.2.262.1.10.12.0", LiabilityLimitationFlagExtension.class);
            oidImplementations.put("0.2.262.1.10.12", LiabilityLimitationFlagExtension.class);
            oidImplementations.put("1.3.6.1.4.1.8301.3.5", ValidityModelExtension.class);
            oidImplementations.put("1.3.36.8.3.1", CertGenerationDateExtension.class);
            oidImplementations.put("1.3.36.8.3.6", ICCSNExtension.class);
            oidImplementations.put("1.3.6.1.5.5.7.48.1.5", OCSPNoCheckExtension.class);
            oidImplementations.put("2.5.29.21", CRLReasonExtension.class);
            oidImplementations.put("2.5.29.20", CRLNumberExtension.class);
            oidImplementations.put("2.5.29.29", CertificateIssuerExtension.class);
            oidImplementations.put("2.5.29.28", IssuingDistributionPointExtension.class);
            oidImplementations.put("2.16.840.1.113730.1.1", NetscapeCertificateTypeExtension.class);
            oidImplementations.put("1.3.36.8.3.13", CertHashExtension.class);
        }
        return oidImplementations;
    }

    public static Extension forOID(Extension _ext) {
        if (_ext == null) {
            return null;
        }
        Class<? extends Extension> clazz = ExtensionFactory.getOIDImplementations().get(_ext.getOID());
        if (clazz == null) {
            clazz = UnprocessedExtension.class;
        }
        try {
            Constructor<? extends Extension> constructor = clazz.getConstructor(Run.class);
            Source source = _ext.getSource();
            return constructor.newInstance(Run.create(source, _ext.getOffset()));
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public static synchronized Comparator<Extension> getComparator() {
        if (extOrderer == null) {
            extOrderer = new ExtComparator("Extension.order");
        }
        return extOrderer;
    }

    public static Collection<String> getCommonPKI_OIDs() {
        return ((ExtComparator)ExtensionFactory.getCommonPKIComparator()).getOIDs();
    }

    public static synchronized Comparator<Extension> getCommonPKIComparator() {
        if (commonPKIExtOrderer == null) {
            commonPKIExtOrderer = new ExtComparator("ISIS_MTT_Extension.order");
        }
        return commonPKIExtOrderer;
    }

    public static String nameFor(OBJECTIDENTIFIER _objectID) {
        Class<? extends Extension> clazz = ExtensionFactory.getOIDImplementations().get(_objectID.getOID());
        if (clazz == null) {
            return "Unprocessed (" + _objectID.getOID() + ")";
        }
        String s = clazz.getName();
        return s.substring(s.lastIndexOf(46) + 1, s.length() - "Extension".length());
    }

    public static void main(String[] args) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1.3.36.8.3.3", "static public final String Admission = \"1.3.36.8.3.3\"");
        map.put("1.3.36.8.3.15", "static public final String AdditionalInformation = \"1.3.36.8.3.15\"");
        map.put("1.3.6.1.5.5.7.1.1", "static public final String AuthorityInfoAccess = \"1.3.6.1.5.5.7.1.1\"");
        map.put("2.5.29.35", "static public final String AuthorityKeyIdentifier = \"2.5.29.35\"");
        map.put("1.3.36.8.3.1", "static public final String CertGenerationDate = \"1.3.36.8.3.1\"");
        map.put("1.3.36.8.3.13", "static public final String CertHash = \"1.3.36.8.3.13\"");
        map.put("2.5.29.32", "static public final String CertificatePolicies = \"2.5.29.32\"");
        map.put("2.5.29.31", "static public final String CRLDistributionPoints = \"2.5.29.31\"");
        map.put("1.3.36.8.3.5", "static public final String DeclarationOfMajority = \"1.3.36.8.3.5\"");
        map.put("2.5.29.37", "static public final String ExtendedKeyUsage = \"2.5.29.37\"");
        map.put("1.3.36.8.3.6", "static public final String ICCSN = \"1.3.36.8.3.6\"");
        map.put("2.5.29.18", "static public final String IssuerAltNames = \"2.5.29.18\"");
        map.put("2.5.29.15", "static public final String KeyUsage = \"2.5.29.15\"");
        map.put("0.2.262.1.10.12", "static public final String LiabilityLimitationFlag2 = \"0.2.262.1.10.12\"");
        map.put("0.2.262.1.10.12.0", "static public final String LiabilityLimitationFlag = \"0.2.262.1.10.12.0\"");
        map.put("1.3.36.8.3.4", "static public final String MonetaryLimit = \"1.3.36.8.3.4\"");
        map.put("2.5.29.30", "static public final String NameConstraints = \"2.5.29.30\"");
        map.put("1.3.6.1.5.5.7.48.1.5", "static public final String OCSPNoCheck = \"1.3.6.1.5.5.7.48.1.5\"");
        map.put("2.5.29.36", "static public final String PolicyConstraints = \"2.5.29.36\"");
        map.put("2.5.29.33", "static public final String PolicyMappings = \"2.5.29.33\"");
        map.put("1.3.36.8.3.2", "static public final String Procuration = \"1.3.36.8.3.2\"");
        map.put("1.3.6.1.5.5.7.1.3", "static public final String QCStatements = \"1.3.6.1.5.5.7.1.3\"");
        map.put("1.3.36.8.3.8", "static public final String Restriction = \"1.3.36.8.3.8\"");
        map.put("2.5.29.17", "static public final String SubjectAltNames = \"2.5.29.17\"");
        map.put("2.5.29.9", "static public final String SubjectDirectoryAttributes = \"2.5.29.9\"");
        map.put("2.5.29.14", "static public final String SubjectKeyIdentifier = \"2.5.29.14\"");
        map.put("1.3.6.1.4.1.8301.3.5", "static public final String ValidityModel = \"1.3.6.1.4.1.8301.3.5\"");
        map.put("2.5.29.19", "static public final String BasicConstraints = \"2.5.29.19\"");
        ArrayList keys = new ArrayList(map.keySet());
        Collections.sort(keys, new Comparator<String>(){

            @Override
            public int compare(String _o1, String _o2) {
                String[] split1 = _o1.split("\\.");
                String[] split2 = _o2.split("\\.");
                int count = Math.min(split1.length, split2.length);
                for (int i = 0; i < count; ++i) {
                    int n = Integer.valueOf(split1[i]).compareTo(Integer.valueOf(split2[i]));
                    if (n == 0) continue;
                    return n;
                }
                return split2.length - split1.length;
            }
        });
        for (String key : keys) {
            System.out.println((String)map.get(key) + ';');
        }
    }

    public static class ExtComparator
    implements Comparator<Extension> {
        private final Map<String, Integer> order = new HashMap<String, Integer>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ExtComparator(String _resourcePath) {
            try {
                InputStream is = ExtensionFactory.class.getResourceAsStream(_resourcePath);
                LineNumberReader r = new LineNumberReader(new InputStreamReader(is));
                try {
                    String line = r.readLine();
                    int n = 0;
                    while (line != null) {
                        if (line.charAt(0) != '#') {
                            String oid = line.substring(0, line.indexOf(61));
                            this.order.put(oid, n++);
                        }
                        line = r.readLine();
                    }
                }
                finally {
                    try {
                        r.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public boolean hasOrder() {
            return !this.order.isEmpty();
        }

        public Collection<String> getOIDs() {
            return this.order.keySet();
        }

        @Override
        public int compare(Extension o1, Extension o2) {
            Integer i2;
            Extension e1 = o1;
            Extension e2 = o2;
            Integer i1 = this.order.get(e1.getOID());
            if (i1 == null) {
                i1 = Integer.MAX_VALUE;
            }
            if ((i2 = this.order.get(e2.getOID())) == null) {
                i2 = Integer.MAX_VALUE;
            }
            return i1.compareTo(i2);
        }
    }
}

