/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.CharString;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.DirectoryString;
import de.bos_bremen.ci.asn1.x509.GeneralName;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class EdiPartyName
extends ANY
implements GeneralName {
    CharString nameAssigner;
    CharString partyName;

    public EdiPartyName(Run _run) throws ParseException {
        this(_run, false);
    }

    public EdiPartyName(Run _run, boolean implicit) throws ParseException {
        super(_run, implicit);
        byte tag = _run.next();
        if (!implicit && tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        this.setLength(_run.readLength());
        if (_run.pos() >= this.getEnd()) {
            return;
        }
        tag = _run.get();
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 0) {
            _run.next();
            _run.readLength();
            this.nameAssigner = DirectoryString.Factory.createDirectoryString(_run);
            if (_run.pos() >= this.getEnd()) {
                return;
            }
            tag = _run.get();
        }
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 1) {
            throw new ParseException(this, "explicit DirectoryName expected at index " + _run.pos(), _run.pos());
        }
        _run.next();
        _run.readLength();
        this.partyName = DirectoryString.Factory.createDirectoryString(_run);
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        if (this.nameAssigner != null) {
            w.write(40);
            this.nameAssigner.dump(w);
            w.write(41);
            w.write(32);
        }
        this.partyName.dump(w);
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        return Arrays.asList(new Flattable.Pair(res.getString("general_name.label"), null));
    }

    @Override
    public String getDisplayName() {
        return this.partyName.getValue();
    }
}

