/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.OBJECTIDENTIFIER;
import de.bos_bremen.ci.asn1.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class ETSIQCObjectIdentifier
extends ANY
implements Flattable {
    public static final String OID = "0.4.0.1862.1.6";
    private List<OBJECTIDENTIFIER> qcTypes;

    public ETSIQCObjectIdentifier(Run _run) throws ParseException {
        super(_run, true);
        if (ANY.initSequence(this, _run)) {
            return;
        }
        this.qcTypes = new ArrayList<OBJECTIDENTIFIER>();
        while (_run.pos() < this.getEnd()) {
            this.qcTypes.add(new OBJECTIDENTIFIER(_run));
        }
        if (_run.pos() >= this.getEnd()) {
            return;
        }
        _run.next();
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> pairs = new ArrayList<Flattable.Pair>();
        for (OBJECTIDENTIFIER qcType : this.qcTypes) {
            Flattable.Pair pair;
            if (pairs.isEmpty()) {
                pair = new Flattable.Pair(res.getString(OID), res.getString(qcType.getOID()));
                pairs.add(pair);
                continue;
            }
            pair = new Flattable.Pair(null, res.getString(qcType.getOID()));
            pairs.add(pair);
        }
        return pairs;
    }

    @Deprecated
    public OBJECTIDENTIFIER getOID() {
        return OBJECTIDENTIFIER.valueOf(OID);
    }

    public List<OBJECTIDENTIFIER> getQcTypes() {
        return this.qcTypes;
    }
}

