/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Flattable;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.ASN1;
import de.bos_bremen.ci.asn1.DumpWriter;
import de.bos_bremen.ci.asn1.Dumpable;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.x509.DistributionPointName;
import de.bos_bremen.ci.asn1.x509.GeneralName;
import de.bos_bremen.ci.asn1.x509.ReasonFlags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;

public class DistributionPoint
extends ANY
implements Dumpable,
Flattable {
    DistributionPointName distributionPoint;
    ReasonFlags reasons;
    GeneralName crlIssuer;

    public DistributionPoint(Run _run) throws ParseException {
        super(_run, false);
        byte tag = _run.next();
        if (tag != 48) {
            throw new ParseException(this, ASN1.Factory.toString((byte)48) + " expected at index " + _run.pos(), _run.pos());
        }
        int end = _run.readLength();
        this.setEnd(end += _run.pos());
        if (_run.pos() >= end) {
            return;
        }
        tag = _run.get();
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 0) {
            _run.next();
            _run.readLength();
            this.distributionPoint = DistributionPointName.Factory.generate(_run);
            if (_run.pos() >= end) {
                return;
            }
            tag = _run.get();
        }
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 1) {
            this.reasons = new ReasonFlags(_run, true);
            if (_run.pos() >= end) {
                return;
            }
            tag = _run.get();
        }
        if (ASN1.Factory.isTagged(tag) && (tag & 0xF) == 2) {
            _run.next();
            _run.readLength();
            this.crlIssuer = GeneralName.Factory.generate(_run);
        }
    }

    @Override
    public void dump(DumpWriter w) throws IOException {
        ANY.writeClassName(this, w);
        w.write(32);
        w.write(123);
        w.indent();
        w.newLine();
        if (this.distributionPoint != null) {
            this.distributionPoint.dump(w);
        }
        if (this.reasons != null) {
            if (this.distributionPoint != null) {
                w.newLine();
            }
            this.reasons.dump(w);
            w.newLine();
        }
        if (this.crlIssuer != null) {
            if (this.reasons != null || this.distributionPoint != null) {
                w.newLine();
            }
            this.crlIssuer.dump(w);
        }
        w.outdent();
        w.newLine();
        w.write(125);
    }

    @Override
    public List<Flattable.Pair> flatten(ResourceBundle res, boolean _short) {
        ArrayList<Flattable.Pair> result = new ArrayList<Flattable.Pair>();
        if (this.distributionPoint != null) {
            result.addAll(this.distributionPoint.flatten(res, false));
        }
        if (this.reasons != null) {
            result.add(new Flattable.Pair("distributionpoint.reasonflags", this.reasons.toString()));
        }
        if (this.crlIssuer != null) {
            result.add(new Flattable.Pair(res.getString("distributionpoint.crlissuer"), ""));
            result.addAll(this.crlIssuer.flatten(res, false));
        }
        return result;
    }

    public DistributionPointName getName() {
        return this.distributionPoint;
    }

    public GeneralName getCrlIssuer() {
        return this.crlIssuer;
    }

    public ReasonFlags getReasons() {
        return this.reasons;
    }
}

