/*
 * Decompiled with CFR 0.152.
 */
package de.bos_bremen.ci.asn1.x509;

import de.bos_bremen.ci.Hex;
import de.bos_bremen.ci.Run;
import de.bos_bremen.ci.asn1.ANY;
import de.bos_bremen.ci.asn1.BMPString;
import de.bos_bremen.ci.asn1.CharString;
import de.bos_bremen.ci.asn1.IA5String;
import de.bos_bremen.ci.asn1.ParseException;
import de.bos_bremen.ci.asn1.UTF8String;
import de.bos_bremen.ci.asn1.VisibleString;
import de.bos_bremen.ci.asn1.x509.DirectoryString;

public interface DisplayText
extends DirectoryString {

    public static final class Factory {
        public static CharString createDisplayText(Run _run) throws ParseException {
            byte tag = _run.get();
            switch (tag) {
                case 22: {
                    return new IA5String(_run);
                }
                case 26: {
                    return new VisibleString(_run);
                }
                case 30: {
                    return new BMPString(_run);
                }
                case 12: {
                    return new UTF8String(_run);
                }
            }
            ANY any = new ANY(_run, false);
            throw new ParseException(any, "no representation for choice \"" + Hex.hexify(tag) + "\" at index " + _run.pos(), _run.pos());
        }
    }
}

